/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.facade;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.app.decompiler.DecompileException;
import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.GenSignatures;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.facade.FunctionSymbolIterator;
import ghidra.features.bsim.query.facade.QueryDatabaseException;
import ghidra.features.bsim.query.facade.SFOverviewInfo;
import ghidra.features.bsim.query.facade.SFQueryInfo;
import ghidra.features.bsim.query.facade.SFQueryResult;
import ghidra.features.bsim.query.facade.SFResultsUpdateListener;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.FunctionStaging;
import ghidra.features.bsim.query.protocol.NullStaging;
import ghidra.features.bsim.query.protocol.PasswordChange;
import ghidra.features.bsim.query.protocol.QueryNearest;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.ResponseNearest;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.features.bsim.query.protocol.ResponsePassword;
import ghidra.features.bsim.query.protocol.StagingManager;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class SimilarFunctionQueryService
implements AutoCloseable {
    private FunctionDatabase database = null;
    private Program program;
    private GenSignatures signatureGenerator;
    private int numStages;

    public SimilarFunctionQueryService(Program program) {
        this.program = program;
        this.numStages = 0;
    }

    SimilarFunctionQueryService(Program program, FunctionDatabase database) {
        this.program = program;
        this.database = database;
        this.numStages = 0;
    }

    public QueryNearest generateQueryNearest(SFQueryInfo queryInfo, TaskMonitor monitor) throws QueryDatabaseException {
        QueryNearest result = queryInfo.buildQueryNearest();
        this.doSignatureGeneration(queryInfo.getFunctions(), monitor);
        FunctionSymbolIterator iter = new FunctionSymbolIterator(queryInfo.getFunctions().iterator());
        try {
            this.signatureGenerator.transferCachedFunctions(result.manage, iter, queryInfo.getPreFilter());
        }
        catch (LSHException e) {
            throw new QueryDatabaseException(e.getMessage());
        }
        return result;
    }

    public QueryNearestVector generateQueryNearestVector(SFOverviewInfo overviewInfo, TaskMonitor monitor) throws QueryDatabaseException {
        QueryNearestVector result = overviewInfo.buildQueryNearestVector();
        this.doSignatureGeneration(overviewInfo.getFunctions(), monitor);
        FunctionSymbolIterator iter = new FunctionSymbolIterator(overviewInfo.getFunctions().iterator());
        try {
            this.signatureGenerator.transferCachedFunctions(result.manage, iter, overviewInfo.getPreFilter());
        }
        catch (LSHException e) {
            throw new QueryDatabaseException(e.getMessage());
        }
        return result;
    }

    @Deprecated
    public String changePassword(String username, char[] newPassword) {
        if (this.database == null || this.database.getStatus() != FunctionDatabase.Status.Ready) {
            return "Connection not established";
        }
        PasswordChange passwordChange = new PasswordChange();
        passwordChange.username = username;
        passwordChange.newPassword = newPassword;
        ResponsePassword response = (ResponsePassword)passwordChange.execute(this.database);
        if (!response.changeSuccessful) {
            return response.errorMessage;
        }
        return null;
    }

    public SFQueryResult querySimilarFunctions(SFQueryInfo queryInfo, SFResultsUpdateListener<SFQueryResult> listener, TaskMonitor monitor) throws QueryDatabaseException, CancelledException {
        SFQueryResult result = null;
        try {
            if (this.database == null || this.database.getStatus() != FunctionDatabase.Status.Ready) {
                throw new QueryDatabaseException("Connection with database not established");
            }
            if (monitor == null) {
                monitor = TaskMonitor.DUMMY;
            }
            if (listener == null) {
                listener = new NullListener<SFQueryResult>();
            }
            QueryNearest query = this.generateQueryNearest(queryInfo, monitor);
            int localNumStages = this.numStages;
            if (localNumStages == 0) {
                int funcsPerStage = this.database.getQueriedFunctionsPerStage();
                localNumStages = queryInfo.getNumberOfStages(funcsPerStage);
            }
            StagingManager stagingManager = this.createStagingManager(queryInfo.getFunctions().size(), localNumStages);
            ResponseNearest response = (ResponseNearest)this.doQuery(query, stagingManager, listener, monitor);
            result = new SFQueryResult(queryInfo, this.database.getURLString(), this.database.getInfo(), response);
            listener.setFinalResult(result);
        }
        catch (LSHException e) {
            try {
                throw new QueryDatabaseException(e.getMessage());
            }
            catch (Throwable throwable) {
                listener.setFinalResult(result);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseNearestVector overviewSimilarFunctions(SFOverviewInfo overviewInfo, SFResultsUpdateListener<ResponseNearestVector> listener, TaskMonitor monitor) throws QueryDatabaseException, CancelledException {
        ResponseNearestVector response = null;
        try {
            if (this.database == null || this.database.getStatus() != FunctionDatabase.Status.Ready) {
                throw new QueryDatabaseException("Connection to database not established");
            }
            if (monitor == null) {
                monitor = TaskMonitor.DUMMY;
            }
            if (listener == null) {
                listener = new NullListener<ResponseNearestVector>();
            }
            QueryNearestVector query = this.generateQueryNearestVector(overviewInfo, monitor);
            int localNumStages = this.numStages;
            if (localNumStages == 0) {
                int funcsPerStage = this.database.getOverviewFunctionsPerStage();
                localNumStages = overviewInfo.getNumberOfStages(funcsPerStage);
            }
            StagingManager stagingManager = this.createStagingManager(overviewInfo.getFunctions().size(), localNumStages);
            try {
                response = (ResponseNearestVector)this.doQuery(query, stagingManager, listener, monitor);
            }
            catch (LSHException e) {
                throw new QueryDatabaseException(e.getMessage());
            }
            listener.setFinalResult(response);
        }
        catch (Throwable throwable) {
            listener.setFinalResult(response);
            throw throwable;
        }
        return response;
    }

    public QueryResponseRecord queryRaw(BSimQuery<?> query, StagingManager stagingManager, SFResultsUpdateListener<QueryResponseRecord> listener, TaskMonitor monitor) throws QueryDatabaseException, CancelledException {
        QueryResponseRecord response = null;
        try {
            if (this.database == null || this.database.getStatus() != FunctionDatabase.Status.Ready) {
                throw new QueryDatabaseException("Connection to database not established");
            }
            if (monitor == null) {
                monitor = TaskMonitor.DUMMY;
            }
            if (listener == null) {
                listener = new NullListener<QueryResponseRecord>();
            }
            if (stagingManager == null) {
                stagingManager = new NullStaging();
            }
            response = this.doQuery(query, stagingManager, listener, monitor);
            listener.setFinalResult(response);
        }
        catch (LSHException e) {
            try {
                throw new QueryDatabaseException(e.getMessage());
            }
            catch (Throwable throwable) {
                listener.setFinalResult(response);
                throw throwable;
            }
        }
        return response;
    }

    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (this.database != null) {
            this.database.close();
            this.database = null;
        }
        if (this.signatureGenerator != null) {
            this.signatureGenerator.dispose();
            this.signatureGenerator = null;
        }
    }

    public void setNumberOfStages(int val) {
        this.numStages = val;
    }

    public void updateProgram(Program newProgram) {
        if (this.program != newProgram) {
            this.program = newProgram;
            this.signatureGenerator = null;
        }
    }

    private QueryResponseRecord doQuery(BSimQuery<?> query, StagingManager stagingManager, SFResultsUpdateListener<?> listener, TaskMonitor monitor) throws LSHException, CancelledException {
        boolean haveMore = stagingManager.initialize(query);
        query.buildResponseTemplate();
        Object globalResponse = query.getResponse();
        monitor.setMessage("Querying database");
        monitor.initialize((long)stagingManager.getTotalSize());
        while (haveMore) {
            monitor.checkCancelled();
            BSimQuery<?> stagedQuery = stagingManager.getQuery();
            Object response = stagedQuery.execute(this.database);
            if (response != null) {
                if (globalResponse != response) {
                    ((QueryResponseRecord)globalResponse).mergeResults((QueryResponseRecord)response);
                }
                listener.resultAdded((QueryResponseRecord)response);
                haveMore = stagingManager.nextStage();
                if (haveMore) {
                    stagedQuery.clearResponse();
                }
                monitor.setProgress((long)stagingManager.getQueriesMade());
                continue;
            }
            throw new LSHException(this.database.getLastError().message);
        }
        return globalResponse;
    }

    public BSimServerInfo getServerInfo() {
        if (this.database == null) {
            return null;
        }
        return this.database.getServerInfo();
    }

    public FunctionDatabase.Status getDatabaseStatus() {
        if (this.database == null) {
            return FunctionDatabase.Status.Unconnected;
        }
        return this.database.getStatus();
    }

    public FunctionDatabase.ConnectionType getDatabaseConnectionType() {
        if (this.database == null) {
            return FunctionDatabase.ConnectionType.Unencrypted_No_Authentication;
        }
        return this.database.getConnectionType();
    }

    public DatabaseInformation getDatabaseInformation() {
        if (this.database == null) {
            return null;
        }
        return this.database.getInfo();
    }

    public String getUserName() {
        if (this.database == null) {
            return null;
        }
        return this.database.getUserName();
    }

    public LSHVectorFactory getLSHVectorFactory() {
        if (this.database == null) {
            return null;
        }
        return this.database.getLSHVectorFactory();
    }

    public FunctionDatabase.Error getLastError() {
        if (this.database == null) {
            return null;
        }
        return this.database.getLastError();
    }

    public String getDatabaseCompatibility() {
        if (this.database == null) {
            return null;
        }
        DatabaseInformation info = this.database.getInfo();
        if (info == null) {
            return null;
        }
        int compare = this.database.compareLayout();
        if (compare < 0) {
            return "This client is incompatible with the earlier database format on the server";
        }
        if (compare > 0) {
            return "The server is using a later database format than is supported by this client";
        }
        return null;
    }

    protected FunctionDatabase createDatabase(String urlString) throws MalformedURLException {
        URL url = BSimClientFactory.deriveBSimURL(urlString);
        return BSimClientFactory.buildClient(url, false);
    }

    public void initializeDatabase(String serverURLString) throws QueryDatabaseException {
        if (this.isSameDatabase(serverURLString) && this.database.getStatus() == FunctionDatabase.Status.Ready) {
            return;
        }
        if (this.database != null) {
            this.database.close();
            this.database = null;
        }
        try {
            this.database = this.createDatabase(serverURLString);
        }
        catch (MalformedURLException e) {
            throw new QueryDatabaseException("Bad database URL: " + e.getMessage());
        }
        boolean success = this.database.initialize();
        if (!success) {
            String errorMsg = "";
            if (this.database.getLastError() != null) {
                errorMsg = this.database.getLastError().message;
            }
            throw new QueryDatabaseException(errorMsg);
        }
    }

    private boolean isSameDatabase(String serverURLString) {
        if (this.database == null) {
            return false;
        }
        return this.database.getURLString().equals(serverURLString);
    }

    private void doSignatureGeneration(Set<FunctionSymbol> functions, TaskMonitor monitor) throws QueryDatabaseException {
        if (functions.isEmpty()) {
            return;
        }
        if (this.signatureGenerator == null) {
            this.signatureGenerator = this.createSignatureGenerator();
        }
        try {
            this.signatureGenerator.setVectorFactory(this.database.getLSHVectorFactory());
        }
        catch (LSHException e1) {
            throw new QueryDatabaseException(e1);
        }
        monitor.setMessage("Hashing function signatures...");
        FunctionSymbolIterator iter = new FunctionSymbolIterator(functions.iterator());
        int count = functions.size();
        try {
            this.signatureGenerator.scanFunctions(iter, count, monitor);
        }
        catch (DecompileException e) {
            throw new QueryDatabaseException((Exception)((Object)e));
        }
    }

    private GenSignatures createSignatureGenerator() throws QueryDatabaseException {
        try {
            GenSignatures newSignatureGenerator = new GenSignatures(false);
            newSignatureGenerator.openProgram(this.program, null, null, null, null, null);
            return newSignatureGenerator;
        }
        catch (LSHException e) {
            throw new QueryDatabaseException("Unable to signature functions", e);
        }
    }

    private StagingManager createStagingManager(int numqueries, int stages) {
        if (stages == 1) {
            return new NullStaging();
        }
        int numberOfFunctionsPerQuery = stages > numqueries ? 1 : (int)Math.ceil(numqueries / stages);
        return new FunctionStaging(numberOfFunctionsPerQuery);
    }

    private class NullListener<R>
    implements SFResultsUpdateListener<R> {
        private NullListener() {
        }

        @Override
        public void resultAdded(QueryResponseRecord response) {
        }

        @Override
        public void setFinalResult(R result) {
        }
    }
}

