/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr.match;

import ghidra.app.plugin.assembler.sleigh.expr.match.AnyMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.BinaryExpressionMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.ConstantValueMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.FieldSizeMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.OperandValueMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.UnaryExpressionMatcher;
import ghidra.app.plugin.processors.sleigh.expression.AndExpression;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import ghidra.app.plugin.processors.sleigh.expression.DivExpression;
import ghidra.app.plugin.processors.sleigh.expression.LeftShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.MinusExpression;
import ghidra.app.plugin.processors.sleigh.expression.MultExpression;
import ghidra.app.plugin.processors.sleigh.expression.NotExpression;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.OrExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.expression.PlusExpression;
import ghidra.app.plugin.processors.sleigh.expression.RightShiftExpression;
import ghidra.app.plugin.processors.sleigh.expression.SubExpression;
import ghidra.app.plugin.processors.sleigh.expression.XorExpression;
import java.util.HashMap;
import java.util.Map;

public interface ExpressionMatcher<T extends PatternExpression> {
    default public Map<ExpressionMatcher<?>, PatternExpression> match(PatternExpression expression) {
        HashMap result = new HashMap();
        if (this.match(expression, result)) {
            return result;
        }
        return null;
    }

    default public T get(Map<ExpressionMatcher<?>, PatternExpression> results) {
        return (T)results.get(this);
    }

    public boolean match(PatternExpression var1, Map<ExpressionMatcher<?>, PatternExpression> var2);

    public static interface Context {
        default public ExpressionMatcher<AndExpression> and(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher.Commutative<AndExpression>(AndExpression.class, left, right);
        }

        default public ExpressionMatcher<DivExpression> div(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher<DivExpression>(DivExpression.class, left, right);
        }

        default public ExpressionMatcher<LeftShiftExpression> shl(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher<LeftShiftExpression>(LeftShiftExpression.class, left, right);
        }

        default public ExpressionMatcher<MultExpression> mul(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher.Commutative<MultExpression>(MultExpression.class, left, right);
        }

        default public ExpressionMatcher<OrExpression> or(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher.Commutative<OrExpression>(OrExpression.class, left, right);
        }

        default public ExpressionMatcher<PlusExpression> plus(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher<PlusExpression>(PlusExpression.class, left, right);
        }

        default public ExpressionMatcher<RightShiftExpression> shr(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher<RightShiftExpression>(RightShiftExpression.class, left, right);
        }

        default public ExpressionMatcher<SubExpression> sub(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher<SubExpression>(SubExpression.class, left, right);
        }

        default public ExpressionMatcher<XorExpression> xor(ExpressionMatcher<?> left, ExpressionMatcher<?> right) {
            return new BinaryExpressionMatcher<XorExpression>(XorExpression.class, left, right);
        }

        default public ExpressionMatcher<ConstantValue> cv(long value) {
            return new ConstantValueMatcher(value);
        }

        default public ExpressionMatcher<PatternExpression> var() {
            return AnyMatcher.any();
        }

        default public <T extends PatternExpression> ExpressionMatcher<T> var(Class<T> cls) {
            return new AnyMatcher<T>(cls);
        }

        default public ExpressionMatcher<OperandValue> opnd(ExpressionMatcher<?> def) {
            return new OperandValueMatcher(def);
        }

        default public ExpressionMatcher<PatternValue> fldSz(ExpressionMatcher<?> size) {
            return new FieldSizeMatcher(size);
        }

        default public ExpressionMatcher<MinusExpression> neg(ExpressionMatcher<?> unary) {
            return new UnaryExpressionMatcher<MinusExpression>(MinusExpression.class, unary);
        }

        default public ExpressionMatcher<NotExpression> not(ExpressionMatcher<?> unary) {
            return new UnaryExpressionMatcher<NotExpression>(NotExpression.class, unary);
        }
    }
}

