/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.symbol;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseNumericToken;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class AssemblyNumericMapTerminal
extends AssemblyNumericTerminal {
    protected final Map<Long, Integer> map;

    public AssemblyNumericMapTerminal(String name, Map<Long, Integer> map) {
        super(name, 0, null);
        this.map = map;
    }

    @Override
    public Collection<AssemblyParseNumericToken> match(String buffer, int pos, AssemblyGrammar grammar, AssemblyNumericSymbols symbols) {
        HashSet<AssemblyParseNumericToken> toks = new HashSet<AssemblyParseNumericToken>(super.match(buffer, pos, grammar, AssemblyNumericSymbols.EMPTY));
        LinkedHashSet<AssemblyParseNumericToken> results = new LinkedHashSet<AssemblyParseNumericToken>();
        for (AssemblyParseNumericToken tok : toks) {
            Integer mapped = this.map.get(tok.getNumericValue());
            if (mapped == null) continue;
            results.add(new AssemblyParseNumericToken(grammar, this, tok.getString(), mapped.intValue()));
        }
        return results;
    }

    @Override
    public Collection<String> getSuggestions(String got, AssemblyNumericSymbols symbols) {
        HashSet<String> result = new HashSet<String>();
        for (long k : this.map.keySet()) {
            result.add(Long.toString(k));
            result.add(Long.toHexString(k));
        }
        return result;
    }
}

