/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import generic.jar.ResourceFile;
import ghidra.app.plugin.processors.sleigh.SleighCompilerSpecDescription;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighLanguageValidator;
import ghidra.framework.Application;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageProvider;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utilities.util.FileResolutionResult;
import utilities.util.FileUtilities;

public class SleighLanguageProvider
implements LanguageProvider {
    private static final Pattern RELATIVE_PATHS_PATTERN = Pattern.compile(".*(\\/|\\\\)\\.\\.?(\\/|\\\\)|\\.(\\/|\\\\)|\\.\\.(\\/|\\\\)");
    private final LinkedHashMap<LanguageID, SleighLanguage> languages = new LinkedHashMap();
    private final LinkedHashMap<LanguageID, SleighLanguageDescription> descriptions = new LinkedHashMap();
    private int failureCount = 0;
    public static final String LANGUAGE_DIR_NAME = "languages";
    private static SleighLanguageProvider instance;

    public static synchronized SleighLanguageProvider getSleighLanguageProvider() {
        if (instance == null) {
            instance = new SleighLanguageProvider();
        }
        return instance;
    }

    private SleighLanguageProvider() {
        try {
            this.createLanguages();
        }
        catch (Exception e) {
            Msg.error(SleighLanguageProvider.class, (Object)"Sleigh language provider initiailization failed", (Throwable)e);
        }
    }

    SleighLanguageProvider(ResourceFile ldefsFile) throws SAXException, IOException {
        this.createLanguages(ldefsFile);
    }

    private void createLanguages() throws Exception {
        List files = Application.findFilesByExtensionInApplication((String)".ldefs");
        for (ResourceFile file : files) {
            this.createLanguages(file);
        }
    }

    private void createLanguages(ResourceFile file) throws SAXException, IOException {
        try {
            SleighLanguageValidator.validateLdefsFile(file);
            this.createLanguageDescriptions(file);
        }
        catch (SleighException e) {
            ++this.failureCount;
            Msg.showError((Object)this, null, (String)("Problem loading " + file.getName()), (Object)("Validation error: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean hadLoadFailure() {
        return this.failureCount != 0;
    }

    @Override
    public boolean isLanguageLoaded(LanguageID languageId) {
        return this.languages.get(languageId) != null;
    }

    @Override
    public Language getLanguage(LanguageID languageId) {
        SleighLanguageDescription description = this.descriptions.get(languageId);
        SleighLanguage lang = this.languages.get(languageId);
        if (lang == null && description != null) {
            try {
                lang = new SleighLanguage(description);
                this.languages.put(languageId, lang);
            }
            catch (SleighException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)("Can't read language spec " + description.getSlaFile().getAbsolutePath()), (Throwable)e);
                throw e;
            }
            catch (FileNotFoundException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)("Can't read language spec " + description.getSlaFile().getAbsolutePath()), (Throwable)e);
                throw new SleighException("File not found - language probably did not compile properly", e);
            }
            catch (UnknownInstructionException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)("Can't read language spec " + description.getSlaFile().getAbsolutePath()), (Throwable)((Object)e));
                throw new SleighException("Unknown instruction - language probably did not compile properly", (Throwable)((Object)e));
            }
            catch (SAXException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)("Can't read language spec " + description.getSlaFile().getAbsolutePath()), (Throwable)e);
                throw new SleighException("SAXException - language probably did not compile properly", e);
            }
            catch (IOException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)("Can't read language spec " + description.getSlaFile().getAbsolutePath()), (Throwable)e);
                throw new SleighException("IOException - language probably did not compile properly", e);
            }
        }
        return lang;
    }

    void unloadLanguage(LanguageID languageID) {
        if (this.languages.containsKey(languageID)) {
            this.languages.put(languageID, null);
        }
    }

    @Override
    public LanguageDescription[] getLanguageDescriptions() {
        LanguageDescription[] d = new LanguageDescription[this.descriptions.size()];
        this.descriptions.values().toArray(d);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLanguageDescriptions(final ResourceFile specFile) throws SAXException, IOException {
        ErrorHandler errHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Msg.error((Object)SleighLanguageProvider.this, (Object)("Error parsing " + specFile), (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Msg.error((Object)SleighLanguageProvider.this, (Object)("Fatal error parsing " + specFile), (Throwable)exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)SleighLanguageProvider.this, (Object)("Warning parsing " + specFile), (Throwable)exception);
            }
        };
        XmlPullParser parser = XmlPullParserFactory.create((ResourceFile)specFile, (ErrorHandler)errHandler, (boolean)false);
        try {
            this.read(parser, specFile.getParentFile(), specFile.getName());
        }
        finally {
            parser.dispose();
        }
    }

    private void read(XmlPullParser parser, ResourceFile parentDirectory, String ldefs) {
        XmlElement languageEnter;
        XmlElement start = parser.start(new String[]{"language_definitions"});
        while ((languageEnter = parser.softStart(new String[]{"language"})) != null) {
            ResourceFile defsFile;
            SleighLanguageDescription description;
            LanguageID id;
            block25: {
                ResourceFile slaFile;
                XmlElement externalName;
                XmlElement compiler;
                XmlElement element;
                Endian endian;
                boolean hidden = SpecXmlUtils.decodeBoolean((String)languageEnter.getAttribute("hidden"));
                if (hidden && !SystemUtilities.isInDevelopmentMode()) {
                    parser.discardSubTree(languageEnter);
                    continue;
                }
                id = new LanguageID(languageEnter.getAttribute("id"));
                String processorName = languageEnter.getAttribute("processor");
                Endian instructionEndian = endian = Endian.valueOf(languageEnter.getAttribute("endian").toUpperCase());
                if (languageEnter.hasAttribute("instructionEndian")) {
                    instructionEndian = Endian.valueOf(languageEnter.getAttribute("instructionEndian").toUpperCase());
                }
                int size = SpecXmlUtils.decodeInt((String)languageEnter.getAttribute("size"));
                String variant = languageEnter.getAttribute("variant");
                String text = languageEnter.getAttribute("version");
                String[] versionPieces = text.split("\\.");
                int version = 1;
                int minorVersion = 0;
                try {
                    version = SpecXmlUtils.decodeInt((String)versionPieces[0]);
                    if (versionPieces.length > 1) {
                        minorVersion = SpecXmlUtils.decodeInt((String)versionPieces[1]);
                    }
                }
                catch (Exception e) {
                    throw new SleighException("Version tag must specify address <major>[.<minor>] version numbers", e);
                }
                boolean deprecated = SpecXmlUtils.decodeBoolean((String)languageEnter.getAttribute("deprecated"));
                String slafilename = languageEnter.getAttribute("slafile");
                String manualindexfile = languageEnter.getAttribute("manualindexfile");
                String pspec = languageEnter.getAttribute("processorspec");
                ArrayList<CompilerSpecDescription> compilerSpecs = new ArrayList<CompilerSpecDescription>();
                while (!parser.peek().getName().equals("description")) {
                    parser.discardSubTree();
                }
                XmlElement descriptionStart = parser.start(new String[0]);
                XmlElement descriptionEnd = parser.end(descriptionStart);
                String descriptionText = descriptionEnd.getText();
                HashMap<String, Integer> truncatedSpaceMap = null;
                HashMap<String, List<String>> externalNameMap = new HashMap<String, List<String>>();
                while ((element = parser.softStart(new String[]{"truncate_space"})) != null) {
                    String spaceName = element.getAttribute("space");
                    int truncatedSize = SpecXmlUtils.decodeInt((String)element.getAttribute("size"));
                    if (truncatedSpaceMap == null) {
                        truncatedSpaceMap = new HashMap<String, Integer>();
                    }
                    if (truncatedSpaceMap.put(spaceName, truncatedSize) != null) {
                        throw new SleighException("truncated space '" + spaceName + "' alread specified");
                    }
                    parser.end(element);
                }
                while ((compiler = parser.softStart(new String[]{"compiler"})) != null) {
                    String compilerID = compiler.getAttribute("id");
                    CompilerSpecID compilerSpecID = new CompilerSpecID(compilerID);
                    String compilerSpecName = compiler.getAttribute("name");
                    String compilerSpecFilename = compiler.getAttribute("spec");
                    ResourceFile compilerSpecFile = this.findFile(parentDirectory, compilerSpecFilename, ".cspec");
                    FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((ResourceFile)compilerSpecFile);
                    if (!result.isOk()) {
                        throw new SleighException("cspec file " + compilerSpecFile + " is not properly case dependent: " + result.getMessage());
                    }
                    SleighCompilerSpecDescription sleighCompilerSpecDescription = new SleighCompilerSpecDescription(compilerSpecID, compilerSpecName, compilerSpecFile);
                    compilerSpecs.add(sleighCompilerSpecDescription);
                    parser.end(compiler);
                }
                while ((externalName = parser.softStart(new String[]{"external_name"})) != null) {
                    String tool = externalName.getAttribute("tool");
                    String name = externalName.getAttribute("name");
                    if (tool != null && name != null && tool.length() > 0 && name.length() > 0) {
                        ArrayList<String> nameList = (ArrayList<String>)externalNameMap.get(tool);
                        if (nameList == null) {
                            nameList = new ArrayList<String>();
                            externalNameMap.put(tool, nameList);
                        }
                        nameList.add(name);
                    }
                    parser.end(externalName);
                }
                while (!parser.peek().isEnd()) {
                    parser.discardSubTree();
                }
                parser.end(languageEnter);
                description = new SleighLanguageDescription(id, descriptionText, Processor.findOrPossiblyCreateProcessor(processorName), endian, instructionEndian, size, variant, version, minorVersion, deprecated, truncatedSpaceMap, compilerSpecs, externalNameMap);
                defsFile = new ResourceFile(parentDirectory, ldefs);
                FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((ResourceFile)defsFile);
                if (!result.isOk()) {
                    throw new SleighException("ldefs file " + defsFile + " is not properly case dependent: " + result.getMessage());
                }
                description.setDefsFile(defsFile);
                ResourceFile specFile = this.findFile(parentDirectory, pspec, ".pspec");
                result = FileUtilities.existsAndIsCaseDependent((ResourceFile)specFile);
                if (!result.isOk()) {
                    throw new SleighException("pspec file " + specFile + " is not properly case dependent: " + result.getMessage());
                }
                description.setSpecFile(specFile);
                try {
                    slaFile = this.findFile(parentDirectory, slafilename, ".slaspec");
                    result = FileUtilities.existsAndIsCaseDependent((ResourceFile)slaFile);
                    if (!result.isOk()) {
                        throw new SleighException("sla file " + slaFile + " is not properly case dependent: " + result.getMessage());
                    }
                    description.setSlaFile(slaFile);
                }
                catch (SleighException e) {
                    int index = slafilename.lastIndexOf(46);
                    String slabase = slafilename.substring(0, index);
                    String slaspecfilename = slabase + ".slaspec";
                    ResourceFile slaspecFile = this.findFile(parentDirectory, slaspecfilename, ".slaspec");
                    result = FileUtilities.existsAndIsCaseDependent((ResourceFile)slaspecFile);
                    if (!result.isOk()) {
                        throw new SleighException("sla file source " + slaspecFile + " is not properly case dependent: " + result.getMessage());
                    }
                    slaFile = new ResourceFile(slaspecFile.getParentFile(), slafilename);
                    description.setSlaFile(slaFile);
                }
                try {
                    if (manualindexfile == null) break block25;
                    ResourceFile manualIndexFile = this.findFile(parentDirectory, manualindexfile, ".idx");
                    result = FileUtilities.existsAndIsCaseDependent((ResourceFile)manualIndexFile);
                    if (result.isOk()) {
                        description.setManualIndexFile(manualIndexFile);
                        break block25;
                    }
                    throw new SleighException(result.getMessage());
                }
                catch (SleighException ex) {
                    Msg.error((Object)this, (Object)ex.getMessage());
                }
            }
            if (this.descriptions.put(id, description) == null) continue;
            Msg.showError((Object)this, null, (String)"Duplicate Sleigh Language ID", (Object)("Language " + id + " previously defined: " + defsFile));
        }
        parser.end(start);
    }

    private ResourceFile findFile(ResourceFile parentDir, String fileNameOrRelativePath, String extension) throws SleighException {
        ResourceFile file = new ResourceFile(parentDir, fileNameOrRelativePath);
        if (file.exists()) {
            return file;
        }
        String fileName = this.getFileNameFromPath(fileNameOrRelativePath);
        List<ResourceFile> files = this.findFiles(fileName, extension);
        if (files.size() == 1) {
            return files.get(0);
        }
        String relativePath = this.discardRelativePath(fileNameOrRelativePath);
        for (ResourceFile resourceFile : files) {
            if (!file.getAbsolutePath().endsWith(relativePath)) continue;
            return resourceFile;
        }
        ResourceFile missingFile = new ResourceFile(parentDir, fileNameOrRelativePath);
        throw new SleighException("Missing sleigh file: " + missingFile.getAbsolutePath());
    }

    private String discardRelativePath(String str) {
        return RELATIVE_PATHS_PATTERN.matcher(str).replaceFirst("");
    }

    private List<ResourceFile> findFiles(String fileName, String extension) {
        ArrayList<ResourceFile> matches = new ArrayList<ResourceFile>();
        List files = Application.findFilesByExtensionInApplication((String)extension);
        for (ResourceFile resourceFile : files) {
            if (!resourceFile.getName().equals(fileName)) continue;
            matches.add(resourceFile);
        }
        return matches;
    }

    private String getFileNameFromPath(String fileNameOrRelativePath) {
        int lastIndexOf = fileNameOrRelativePath.lastIndexOf("/");
        if (lastIndexOf < 0) {
            return fileNameOrRelativePath;
        }
        return fileNameOrRelativePath.substring(lastIndexOf + 1);
    }
}

