/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghpatexpress.AndExpression;
import ghidra.pcodeCPort.slghpatexpress.ConstantValue;
import ghidra.pcodeCPort.slghpatexpress.ContextField;
import ghidra.pcodeCPort.slghpatexpress.DivExpression;
import ghidra.pcodeCPort.slghpatexpress.EndInstructionValue;
import ghidra.pcodeCPort.slghpatexpress.LeftShiftExpression;
import ghidra.pcodeCPort.slghpatexpress.MinusExpression;
import ghidra.pcodeCPort.slghpatexpress.MultExpression;
import ghidra.pcodeCPort.slghpatexpress.Next2InstructionValue;
import ghidra.pcodeCPort.slghpatexpress.NotExpression;
import ghidra.pcodeCPort.slghpatexpress.OperandValue;
import ghidra.pcodeCPort.slghpatexpress.OrExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.PlusExpression;
import ghidra.pcodeCPort.slghpatexpress.RightShiftExpression;
import ghidra.pcodeCPort.slghpatexpress.StartInstructionValue;
import ghidra.pcodeCPort.slghpatexpress.SubExpression;
import ghidra.pcodeCPort.slghpatexpress.TokenField;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghpatexpress.XorExpression;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public abstract class PatternExpression {
    public final Location location;
    private int refcount;

    protected void dispose() {
    }

    public PatternExpression(Location location) {
        this.location = location;
        this.refcount = 0;
    }

    public abstract TokenPattern genMinPattern(VectorSTL<TokenPattern> var1);

    public abstract void listValues(VectorSTL<PatternValue> var1);

    public abstract void getMinMax(VectorSTL<Long> var1, VectorSTL<Long> var2);

    public abstract long getSubValue(VectorSTL<Long> var1, MutableInt var2);

    public abstract void saveXml(PrintStream var1);

    public abstract void restoreXml(Element var1, Translate var2);

    public long getSubValue(VectorSTL<Long> replace) {
        MutableInt listpos = new MutableInt(0);
        return this.getSubValue(replace, listpos);
    }

    public void layClaim() {
        ++this.refcount;
    }

    public static void release(PatternExpression p) {
        --p.refcount;
        if (p.refcount <= 0) {
            p.dispose();
        }
    }

    public static PatternExpression restoreExpression(Element el, Translate trans) {
        PatternExpression res;
        String nm = el.getName();
        if (nm.equals("tokenfield")) {
            res = new TokenField(null);
        } else if (nm.equals("contextfield")) {
            res = new ContextField(null);
        } else if (nm.equals("intb")) {
            res = new ConstantValue(null);
        } else if (nm.equals("operand_exp")) {
            res = new OperandValue(null);
        } else if (nm.equals("start_exp")) {
            res = new StartInstructionValue(null);
        } else if (nm.equals("end_exp")) {
            res = new EndInstructionValue(null);
        } else if (nm.equals("next2_exp")) {
            res = new Next2InstructionValue(null);
        } else if (nm.equals("plus_exp")) {
            res = new PlusExpression(null);
        } else if (nm.equals("sub_exp")) {
            res = new SubExpression(null);
        } else if (nm.equals("mult_exp")) {
            res = new MultExpression(null);
        } else if (nm.equals("lshift_exp")) {
            res = new LeftShiftExpression(null);
        } else if (nm.equals("rshift_exp")) {
            res = new RightShiftExpression(null);
        } else if (nm.equals("and_exp")) {
            res = new AndExpression(null);
        } else if (nm.equals("or_exp")) {
            res = new OrExpression(null);
        } else if (nm.equals("xor_exp")) {
            res = new XorExpression(null);
        } else if (nm.equals("div_exp")) {
            res = new DivExpression(null);
        } else if (nm.equals("minus_exp")) {
            res = new MinusExpression(null);
        } else if (nm.equals("not_exp")) {
            res = new NotExpression(null);
        } else {
            return null;
        }
        ((PatternExpression)res).restoreXml(el, trans);
        return res;
    }
}

