/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpattern;

import ghidra.pcodeCPort.slghpattern.ContextPattern;
import ghidra.pcodeCPort.slghpattern.DisjointPattern;
import ghidra.pcodeCPort.slghpattern.InstructionPattern;
import ghidra.pcodeCPort.slghpattern.OrPattern;
import ghidra.pcodeCPort.slghpattern.Pattern;
import ghidra.pcodeCPort.slghpattern.PatternBlock;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class CombinePattern
extends DisjointPattern {
    private ContextPattern context;
    private InstructionPattern instr;

    @Override
    protected PatternBlock getBlock(boolean cont) {
        return cont ? this.context.getBlock() : this.instr.getBlock();
    }

    public CombinePattern() {
        this.context = null;
        this.instr = null;
    }

    public CombinePattern(ContextPattern con, InstructionPattern in) {
        this.context = con;
        this.instr = in;
    }

    @Override
    public void shiftInstruction(int sa) {
        this.instr.shiftInstruction(sa);
    }

    @Override
    public boolean alwaysInstructionTrue() {
        return this.instr.alwaysInstructionTrue();
    }

    @Override
    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
        }
        if (this.instr != null) {
            this.instr.dispose();
        }
    }

    @Override
    public boolean alwaysTrue() {
        return this.context.alwaysTrue() && this.instr.alwaysTrue();
    }

    @Override
    public boolean alwaysFalse() {
        return this.context.alwaysFalse() || this.instr.alwaysFalse();
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        CombinePattern tmp;
        if (b.numDisjoint() != 0) {
            return b.doAnd(this, -sa);
        }
        if (b instanceof CombinePattern) {
            CombinePattern b2 = (CombinePattern)b;
            ContextPattern c = (ContextPattern)this.context.doAnd(b2.context, 0);
            InstructionPattern i = (InstructionPattern)this.instr.doAnd(b2.instr, sa);
            tmp = new CombinePattern(c, i);
        } else if (b instanceof InstructionPattern) {
            InstructionPattern b3 = (InstructionPattern)b;
            InstructionPattern i = (InstructionPattern)this.instr.doAnd(b3, sa);
            tmp = new CombinePattern((ContextPattern)this.context.simplifyClone(), i);
        } else {
            ContextPattern c = (ContextPattern)this.context.doAnd(b, 0);
            InstructionPattern newpat = (InstructionPattern)this.instr.simplifyClone();
            if (sa < 0) {
                newpat.shiftInstruction(-sa);
            }
            tmp = new CombinePattern(c, newpat);
        }
        return tmp;
    }

    @Override
    public Pattern commonSubPattern(Pattern b, int sa) {
        Pattern tmp;
        if (b.numDisjoint() != 0) {
            return b.commonSubPattern(this, -sa);
        }
        if (b instanceof CombinePattern) {
            CombinePattern b2 = (CombinePattern)b;
            ContextPattern c = (ContextPattern)this.context.commonSubPattern(b2.context, 0);
            InstructionPattern i = (InstructionPattern)this.instr.commonSubPattern(b2.instr, sa);
            tmp = new CombinePattern(c, i);
        } else if (b instanceof InstructionPattern) {
            InstructionPattern b3 = (InstructionPattern)b;
            tmp = this.instr.commonSubPattern(b3, sa);
        } else {
            tmp = this.context.commonSubPattern(b, 0);
        }
        return tmp;
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        if (b.numDisjoint() != 0) {
            return b.doOr(this, -sa);
        }
        DisjointPattern res1 = (DisjointPattern)this.simplifyClone();
        DisjointPattern res2 = (DisjointPattern)b.simplifyClone();
        if (sa < 0) {
            res1.shiftInstruction(-sa);
        } else {
            res2.shiftInstruction(sa);
        }
        return new OrPattern(res1, res2);
    }

    @Override
    public Pattern simplifyClone() {
        if (this.context.alwaysTrue()) {
            return this.instr.simplifyClone();
        }
        if (this.instr.alwaysTrue()) {
            return this.context.simplifyClone();
        }
        if (this.context.alwaysFalse() || this.instr.alwaysFalse()) {
            return new InstructionPattern(false);
        }
        return new CombinePattern((ContextPattern)this.context.simplifyClone(), (InstructionPattern)this.instr.simplifyClone());
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<combine_pat>\n");
        this.context.saveXml(s);
        this.instr.saveXml(s);
        s.append("</combine_pat>\n");
    }

    @Override
    public void restoreXml(Element el) {
        List list = el.getChildren();
        Element child = (Element)list.get(0);
        this.context = new ContextPattern();
        this.context.restoreXml(child);
        child = (Element)list.get(1);
        this.instr = new InstructionPattern();
        this.instr.restoreXml(child);
    }
}

