/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpattern;

import ghidra.pcodeCPort.slghpattern.DisjointPattern;
import ghidra.pcodeCPort.slghpattern.OrPattern;
import ghidra.pcodeCPort.slghpattern.Pattern;
import ghidra.pcodeCPort.slghpattern.PatternBlock;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class ContextPattern
extends DisjointPattern {
    private PatternBlock maskvalue;

    @Override
    protected PatternBlock getBlock(boolean context) {
        return context ? this.maskvalue : null;
    }

    public ContextPattern() {
        this.maskvalue = null;
    }

    public ContextPattern(PatternBlock mv) {
        this.maskvalue = mv;
    }

    public PatternBlock getBlock() {
        return this.maskvalue;
    }

    @Override
    public void dispose() {
        if (this.maskvalue != null) {
            this.maskvalue.dispose();
        }
    }

    @Override
    public Pattern simplifyClone() {
        return new ContextPattern(this.maskvalue.clone());
    }

    @Override
    public void shiftInstruction(int sa) {
    }

    @Override
    public boolean alwaysTrue() {
        return this.maskvalue.alwaysTrue();
    }

    @Override
    public boolean alwaysFalse() {
        return this.maskvalue.alwaysFalse();
    }

    @Override
    public boolean alwaysInstructionTrue() {
        return true;
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        if (b instanceof ContextPattern) {
            ContextPattern b2 = (ContextPattern)b;
            return new OrPattern((DisjointPattern)this.simplifyClone(), (DisjointPattern)b2.simplifyClone());
        }
        return b.doOr(this, -sa);
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        if (b instanceof ContextPattern) {
            ContextPattern b2 = (ContextPattern)b;
            PatternBlock resblock = this.maskvalue.intersect(b2.maskvalue);
            return new ContextPattern(resblock);
        }
        return b.doAnd(this, -sa);
    }

    @Override
    public Pattern commonSubPattern(Pattern b, int sa) {
        if (b instanceof ContextPattern) {
            ContextPattern b2 = (ContextPattern)b;
            PatternBlock resblock = this.maskvalue.commonSubPattern(b2.maskvalue);
            return new ContextPattern(resblock);
        }
        return b.commonSubPattern(this, -sa);
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<context_pat>\n");
        this.maskvalue.saveXml(s);
        s.append("</context_pat>\n");
    }

    @Override
    public void restoreXml(Element el) {
        List list = el.getChildren();
        Element child = (Element)list.get(0);
        this.maskvalue = new PatternBlock(true);
        this.maskvalue.restoreXml(child);
    }
}

