/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.external;

import db.BooleanField;
import db.DBHandle;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class OldExtRefAdapter {
    static final String EXT_REF_TABLE_NAME = "External References";
    static final Schema EXT_REF_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, ShortField.INSTANCE, BooleanField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, BooleanField.INSTANCE}, new String[]{"From Address", "Op Index", "User Defined", "External Name ID", "Label", "External To", "External To Exists"});
    static final int FROM_ADDR_COL = 0;
    static final int OP_INDEX_COL = 1;
    static final int USER_DEFINED_COL = 2;
    static final int EXT_NAME_ID_COL = 3;
    static final int LABEL_COL = 4;
    static final int EXT_TO_ADDR_COL = 5;
    static final int EXT_ADDR_EXISTS_COL = 6;
    private Table refTable;

    private OldExtRefAdapter(DBHandle handle) throws VersionException {
        this.refTable = handle.getTable(EXT_REF_TABLE_NAME);
        if (this.refTable == null) {
            throw new VersionException("Missing Table: External References");
        }
        if (this.refTable.getSchema().getVersion() != 0) {
            throw new VersionException(2, false);
        }
    }

    RecordIterator getRecords() throws IOException {
        return this.refTable.iterator();
    }

    int getRecordCount() {
        return this.refTable.getRecordCount();
    }

    private void moveTable(DBHandle handle, TaskMonitor monitor) throws IOException, CancelledException {
        DBHandle tmpHandle = handle.getScratchPad();
        Table newRefTable = tmpHandle.createTable(EXT_REF_TABLE_NAME, EXT_REF_SCHEMA);
        monitor.setMessage("Processing Old External References...");
        monitor.initialize((long)this.refTable.getRecordCount());
        int count = 0;
        RecordIterator iter = this.refTable.iterator();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            newRefTable.putRecord(iter.next());
            monitor.setProgress((long)(++count));
        }
        handle.deleteTable(EXT_REF_TABLE_NAME);
        this.refTable = newRefTable;
    }

    static OldExtRefAdapter getAdapter(DBHandle dbHandle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        OldExtRefAdapter adapter = new OldExtRefAdapter(dbHandle);
        if (openMode == 3) {
            adapter.moveTable(dbHandle, monitor);
        }
        return adapter;
    }
}

