/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.database.mem.RecoverableAddressIterator;
import ghidra.program.database.mem.RecoverableAddressRangeIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import java.util.Iterator;

class SynchronizedAddressSet
implements AddressSetView {
    private AddressSet set = new AddressSet();

    SynchronizedAddressSet() {
    }

    synchronized void add(AddressSet addrSet) {
        this.set.add(addrSet);
    }

    synchronized void add(Address start, Address end) {
        this.set.add(start, end);
    }

    synchronized void delete(Address start, Address end) {
        this.set.delete(start, end);
    }

    @Override
    public synchronized boolean contains(Address addr) {
        return this.set.contains(addr);
    }

    @Override
    public synchronized boolean contains(Address start, Address end) {
        return this.set.contains(start, end);
    }

    @Override
    public synchronized boolean contains(AddressSetView addrSet) {
        return this.set.contains(addrSet);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public synchronized Address getMinAddress() {
        return this.set.getMinAddress();
    }

    @Override
    public synchronized Address getMaxAddress() {
        return this.set.getMaxAddress();
    }

    @Override
    public synchronized int getNumAddressRanges() {
        return this.set.getNumAddressRanges();
    }

    @Override
    public synchronized AddressRangeIterator getAddressRanges() {
        return this.set.getAddressRanges();
    }

    @Override
    public synchronized AddressRangeIterator getAddressRanges(boolean forward) {
        return this.set.getAddressRanges(forward);
    }

    @Override
    public synchronized AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return new RecoverableAddressRangeIterator(this.set, start, forward);
    }

    @Override
    public synchronized Iterator<AddressRange> iterator() {
        return this.set.getAddressRanges();
    }

    @Override
    public synchronized Iterator<AddressRange> iterator(boolean forward) {
        return this.set.getAddressRanges(forward);
    }

    @Override
    public synchronized Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.set.getAddressRanges(start, forward);
    }

    @Override
    public synchronized long getNumAddresses() {
        return this.set.getNumAddresses();
    }

    @Override
    public synchronized AddressIterator getAddresses(boolean forward) {
        return new RecoverableAddressIterator(this.set, null, forward);
    }

    @Override
    public synchronized AddressIterator getAddresses(Address start, boolean forward) {
        return new RecoverableAddressIterator(this.set, start, forward);
    }

    @Override
    public synchronized boolean intersects(AddressSetView addrSet) {
        return this.set.intersects(addrSet);
    }

    @Override
    public synchronized boolean intersects(Address start, Address end) {
        return this.set.intersects(start, end);
    }

    @Override
    public synchronized AddressSet intersect(AddressSetView addrSet) {
        return this.set.intersect(addrSet);
    }

    @Override
    public synchronized AddressSet intersectRange(Address start, Address end) {
        return this.set.intersectRange(start, end);
    }

    @Override
    public synchronized AddressSet union(AddressSetView addrSet) {
        return this.set.union(addrSet);
    }

    @Override
    public synchronized AddressSet subtract(AddressSetView addrSet) {
        return this.set.subtract(addrSet);
    }

    @Override
    public synchronized AddressSet xor(AddressSetView addrSet) {
        return this.set.xor(addrSet);
    }

    @Override
    public synchronized boolean hasSameAddresses(AddressSetView addrSet) {
        return this.set.hasSameAddresses(addrSet);
    }

    @Override
    public synchronized AddressRange getFirstRange() {
        return this.set.getFirstRange();
    }

    @Override
    public synchronized AddressRange getLastRange() {
        return this.set.getLastRange();
    }

    @Override
    public synchronized AddressRange getRangeContaining(Address address) {
        return this.set.getRangeContaining(address);
    }

    @Override
    public synchronized Address findFirstAddressInCommon(AddressSetView addrSet) {
        return this.set.findFirstAddressInCommon(addrSet);
    }

    public synchronized int hashCode() {
        return this.set.hashCode();
    }

    public synchronized boolean equals(Object obj) {
        return this.set.equals(obj);
    }

    public synchronized String toString() {
        return this.set.toString();
    }
}

