/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.util.ErrorHandler;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.OverlappingNamespaceException;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class NamespaceManager
implements ManagerDB {
    private static final String NAMESPACE_MAP_NAME = "SCOPE ADDRESSES";
    private AddressRangeMapDB namespaceMap;
    private ErrorHandler errHandler;
    private AddressMap addrMap;
    private SymbolManager symbolMgr;
    private Namespace globalNamespace;
    private Lock lock;
    private Namespace lastBodyNamespace;
    private AddressSet lastBody;

    public NamespaceManager(DBHandle handle, ErrorHandler errHandler, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException {
        this.errHandler = errHandler;
        this.addrMap = addrMap;
        this.lock = lock;
        if (handle.getTable("Scope") != null) {
            throw new VersionException("Program is transient development format, not supported");
        }
        this.namespaceMap = new AddressRangeMapDB(handle, addrMap, lock, NAMESPACE_MAP_NAME, errHandler, (Field)LongField.INSTANCE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            this.namespaceMap.clearRange(startAddr, endAddr);
        }
        finally {
            this.clearCache();
            this.lock.release();
        }
    }

    private void clearCache() {
        this.lastBodyNamespace = null;
        this.lastBody = null;
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.clearCache();
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.symbolMgr = program.getSymbolTable();
        this.globalNamespace = program.getGlobalNamespace();
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    void dbError(IOException e) {
        this.errHandler.dbError(e);
    }

    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBody(Namespace namespace, AddressSetView set) throws OverlappingNamespaceException {
        if (set.getNumAddresses() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Namespace body size must be less than 0x7fffffff byte addresses");
        }
        this.lock.acquire();
        try {
            AddressSetView oldBody = this.removeBody(namespace);
            AddressRange range = this.overlapsNamespace(set);
            if (range != null) {
                this.doSetBody(namespace, oldBody);
                throw new OverlappingNamespaceException(range.getMinAddress(), range.getMaxAddress());
            }
            this.doSetBody(namespace, set);
        }
        finally {
            this.clearCache();
            this.lock.release();
        }
    }

    private void doSetBody(Namespace namespace, AddressSetView set) {
        LongField field = new LongField(namespace.getID());
        AddressRangeIterator rangeIter = set.getAddressRanges();
        while (rangeIter.hasNext()) {
            AddressRange range = (AddressRange)rangeIter.next();
            this.namespaceMap.paintRange(range.getMinAddress(), range.getMaxAddress(), (Field)field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSetView removeBody(Namespace namespace) {
        this.lock.acquire();
        try {
            AddressSetView set = this.getAddressSet(namespace);
            AddressRangeIterator iter = set.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                this.namespaceMap.clearRange(range.getMinAddress(), range.getMaxAddress());
            }
            AddressSetView addressSetView = set;
            return addressSetView;
        }
        finally {
            this.clearCache();
            this.lock.release();
        }
    }

    public Namespace getNamespaceContaining(Address addr) {
        Object object;
        Symbol s;
        Field field = this.namespaceMap.getValue(addr);
        if (field != null && (s = this.symbolMgr.getSymbol(field.getLongValue())) != null && (object = s.getObject()) instanceof Namespace) {
            return (Namespace)object;
        }
        return this.globalNamespace;
    }

    public AddressRange overlapsNamespace(AddressSetView set) {
        AddressRangeIterator addressRanges = set.getAddressRanges();
        for (AddressRange addressRange : addressRanges) {
            AddressRangeIterator namesSpaceRanges = this.namespaceMap.getAddressRanges(addressRange.getMinAddress(), addressRange.getMaxAddress());
            AddressRange existingRange = (AddressRange)namesSpaceRanges.next();
            if (existingRange == null) continue;
            return existingRange;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Namespace> getNamespacesOverlapping(AddressSetView set) {
        this.lock.acquire();
        try {
            LinkedHashSet<Long> idSet = new LinkedHashSet<Long>();
            AddressRangeIterator rangeIter = set.getAddressRanges();
            while (rangeIter.hasNext()) {
                AddressRange range = (AddressRange)rangeIter.next();
                AddressRangeIterator namespaceRanges = this.namespaceMap.getAddressRanges(range.getMinAddress(), range.getMaxAddress());
                while (namespaceRanges.hasNext()) {
                    AddressRange namespaceRange = (AddressRange)namespaceRanges.next();
                    Field field = this.namespaceMap.getValue(namespaceRange.getMinAddress());
                    Long id = field.getLongValue();
                    if (idSet.contains(id)) continue;
                    idSet.add(id);
                }
            }
            ArrayList<Namespace> list = new ArrayList<Namespace>(idSet.size());
            Iterator<Namespace> iterator = idSet.iterator();
            while (iterator.hasNext()) {
                Object obj;
                long namespaceID = (Long)iterator.next();
                Symbol s = this.symbolMgr.getSymbol(namespaceID);
                if (s == null || !((obj = s.getObject()) instanceof Namespace)) continue;
                list.add((Namespace)s.getObject());
            }
            iterator = list.iterator();
            return iterator;
        }
        finally {
            this.clearCache();
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSetView getAddressSet(Namespace namespace) {
        this.lock.acquire();
        try {
            if (namespace == this.lastBodyNamespace) {
                AddressSet addressSet = this.lastBody;
                return addressSet;
            }
            AddressSetView mySet = this.getAddressSet(namespace.getID());
            AddressSet set = new AddressSet(mySet);
            SymbolIterator it = this.symbolMgr.getSymbols(namespace);
            while (it.hasNext()) {
                Symbol s = it.next();
                Object obj = s.getObject();
                if (!(obj instanceof Namespace)) continue;
                set.add(((Namespace)obj).getBody());
            }
            this.lastBodyNamespace = namespace;
            this.lastBody = set;
            AddressSet addressSet = set;
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressSetView getAddressSet(long namespaceID) {
        this.lock.acquire();
        try {
            AddressSet addressSet = this.namespaceMap.getAddressSet((Field)new LongField(namespaceID));
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, CancelledException {
        this.lock.acquire();
        try {
            Address rangeEnd = fromAddr.addNoWrap(length - 1L);
            AddressSet addrSet = new AddressSet(fromAddr, rangeEnd);
            ArrayList<NamespaceHolder> list = new ArrayList<NamespaceHolder>();
            AddressRangeIterator rangeIter = this.namespaceMap.getAddressRanges(fromAddr, rangeEnd);
            while (rangeIter.hasNext() && !addrSet.isEmpty()) {
                monitor.checkCancelled();
                AddressRange range = (AddressRange)rangeIter.next();
                Field field = this.namespaceMap.getValue(range.getMinAddress());
                long namespaceID = field.getLongValue();
                AddressSet intersection = addrSet.intersect(this.getAddressSet(namespaceID));
                AddressRangeIterator namespaceRangeIter = intersection.getAddressRanges();
                while (namespaceRangeIter.hasNext() && !monitor.isCancelled()) {
                    AddressRange namespaceRange = (AddressRange)namespaceRangeIter.next();
                    Address startAddr = namespaceRange.getMinAddress();
                    Address endAddr = namespaceRange.getMaxAddress();
                    long offset = startAddr.subtract(fromAddr);
                    startAddr = toAddr.add(offset);
                    offset = endAddr.subtract(fromAddr);
                    endAddr = toAddr.add(offset);
                    AddressRangeImpl newRange = new AddressRangeImpl(startAddr, endAddr);
                    list.add(new NamespaceHolder(namespaceID, newRange));
                }
                addrSet = addrSet.subtract(intersection);
            }
            monitor.checkCancelled();
            this.namespaceMap.clearRange(fromAddr, rangeEnd);
            for (int i = 0; i < list.size(); ++i) {
                monitor.checkCancelled();
                NamespaceHolder h = (NamespaceHolder)list.get(i);
                this.namespaceMap.paintRange(h.range.getMinAddress(), h.range.getMaxAddress(), (Field)new LongField(h.namespaceID));
            }
        }
        finally {
            this.clearCache();
            this.lock.release();
        }
    }

    private class NamespaceHolder {
        long namespaceID;
        AddressRange range;

        NamespaceHolder(long namespaceID, AddressRange range) {
            this.namespaceID = namespaceID;
            this.range = range;
        }
    }
}

