/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.stl.Pair;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.CharsetInfo;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.RenderUnicodeSettingsDefinition;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StringLayoutEnum;
import ghidra.program.model.data.StringRenderBuilder;
import ghidra.program.model.data.StringRenderParser;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicode32DataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Unicode32DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StringDataInstance {
    private static final int ASCII_MAX = 127;
    public static final StringDataInstance NULL_INSTANCE = new StaticStringInstance(null, -1);
    public static final int MAX_STRING_LENGTH = 16384;
    public static final String DEFAULT_CHARSET_NAME = "US-ASCII";
    public static final String UNKNOWN = "??";
    public static final String UNKNOWN_DOT_DOT_DOT = "??...";
    private static final String BOM_RESULT_STR = "\ufeff";
    static final int SIZEOF_PASCAL255_STR_LEN_FIELD = 1;
    static final int SIZEOF_PASCAL64k_STR_LEN_FIELD = 2;
    private final String charsetName;
    private final int charSize;
    private final int paddedCharSize;
    private final StringLayoutEnum stringLayout;
    private final String translatedValue;
    private final Endian endianSetting;
    private final boolean showTranslation;
    private final RenderUnicodeSettingsDefinition.RENDER_ENUM renderSetting;
    private final int length;
    private final MemBuffer buf;
    private static final Map<Pair<StringLayoutEnum, String>, DataType> dataTypeMap = new HashMap<Pair<StringLayoutEnum, String>, DataType>();

    public static boolean isString(Data data) {
        if (data == null || !data.isInitializedMemory()) {
            return false;
        }
        DataType dt = data.getBaseDataType();
        if (dt instanceof AbstractStringDataType) {
            return true;
        }
        if (dt instanceof Array) {
            ArrayStringable as = ArrayStringable.getArrayStringable(((Array)dt).getDataType());
            return as != null && as.hasStringValue(data);
        }
        return false;
    }

    public static boolean isStringDataType(DataType dt) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        return dt instanceof AbstractStringDataType || dt instanceof Array && ArrayStringable.getArrayStringable(((Array)dt).getDataType()) != null;
    }

    public static boolean isChar(Data data) {
        if (data == null) {
            return false;
        }
        DataType dt = data.getBaseDataType();
        return dt instanceof CharDataType || dt instanceof WideCharDataType || dt instanceof WideChar16DataType || dt instanceof WideChar32DataType;
    }

    public static String getCharRepresentation(DataType dataType, byte[] bytes, Settings settings) {
        if (bytes == null || bytes.length == 0) {
            return UNKNOWN;
        }
        if (bytes.length != 1 && StringDataInstance.isSingleAsciiValue(bytes)) {
            bytes = new byte[]{bytes[bytes.length - 1]};
        }
        ByteMemBufferImpl memBuf = new ByteMemBufferImpl(null, bytes, true);
        StringDataInstance sdi = new StringDataInstance(dataType, settings, memBuf, bytes.length);
        return sdi.getCharRepresentation();
    }

    private static boolean isSingleAsciiValue(byte[] bytes) {
        int lsbIndex = bytes.length - 1;
        if (bytes[lsbIndex] < 0) {
            return false;
        }
        for (int i = 0; i < lsbIndex; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static StringDataInstance getStringDataInstance(Data data) {
        ArrayStringable arrayStringable;
        if (data == null) {
            return NULL_INSTANCE;
        }
        DataType dt = data.getBaseDataType();
        if (dt instanceof AbstractStringDataType) {
            return ((AbstractStringDataType)dt).getStringDataInstance(data, data, data.getLength());
        }
        if (dt instanceof Array && data.isInitializedMemory() && (arrayStringable = ArrayStringable.getArrayStringable(((Array)dt).getDataType())) != null && arrayStringable.hasStringValue(data)) {
            return new StringDataInstance(arrayStringable, data, (MemBuffer)data, data.getLength(), true);
        }
        return NULL_INSTANCE;
    }

    public static StringDataInstance getStringDataInstance(DataType dataType, MemBuffer buf, Settings settings, int length) {
        if (dataType instanceof AbstractStringDataType) {
            return ((AbstractStringDataType)dataType).getStringDataInstance(buf, settings, length);
        }
        boolean isArray = dataType instanceof Array;
        if (isArray) {
            dataType = ArrayStringable.getArrayStringable(((Array)dataType).getDataType());
        }
        if (dataType instanceof ArrayStringable && ((ArrayStringable)dataType).hasStringValue(settings) && buf.isInitializedMemory()) {
            return new StringDataInstance(dataType, settings, buf, length, isArray);
        }
        return NULL_INSTANCE;
    }

    public static String makeStringLabel(String prefixStr, String str, DataTypeDisplayOptions options) {
        int codePoint;
        boolean needsUnderscore = false;
        StringBuilder buffer = new StringBuilder();
        int strLength = str.length();
        for (int i = 0; i < strLength && buffer.length() < options.getLabelStringLength(); i += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(i);
            if (StringUtilities.isDisplayable((int)codePoint) && codePoint != 32) {
                if (needsUnderscore) {
                    buffer.append('_');
                    needsUnderscore = false;
                }
                buffer.appendCodePoint(codePoint);
                continue;
            }
            needsUnderscore = true;
        }
        return prefixStr + buffer.toString();
    }

    protected StringDataInstance() {
        this.buf = null;
        this.charSize = 0;
        this.paddedCharSize = 0;
        this.charsetName = UNKNOWN;
        this.translatedValue = null;
        this.stringLayout = StringLayoutEnum.FIXED_LEN;
        this.endianSetting = null;
        this.renderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.ALL;
        this.length = 0;
        this.showTranslation = false;
    }

    public StringDataInstance(DataType dataType, Settings settings, MemBuffer buf, int length) {
        this(dataType, settings, buf, length, false);
    }

    public StringDataInstance(DataType dataType, Settings settings, MemBuffer buf, int length, boolean isArrayElement) {
        settings = settings == null ? SettingsImpl.NO_SETTINGS : settings;
        this.buf = buf;
        this.charsetName = StringDataInstance.getCharsetNameFromDataTypeOrSettings(dataType, settings);
        this.charSize = CharsetInfo.getInstance().getCharsetCharSize(this.charsetName);
        this.paddedCharSize = dataType instanceof ArrayStringable && this.charSize == 1 ? StringDataInstance.getDataOrganization(dataType).getCharSize() : this.charSize;
        this.stringLayout = isArrayElement ? StringLayoutEnum.NULL_TERMINATED_BOUNDED : StringDataInstance.getLayoutFromDataType(dataType);
        this.showTranslation = TranslationSettingsDefinition.TRANSLATION.isShowTranslated(settings);
        this.translatedValue = StringDataInstance.getTranslatedValue(settings, buf);
        this.renderSetting = (RenderUnicodeSettingsDefinition.RENDER_ENUM)RenderUnicodeSettingsDefinition.RENDER.getEnumValue(settings);
        this.endianSetting = EndianSettingsDefinition.ENDIAN.getEndianess(settings, null);
        this.length = length;
    }

    private static String getTranslatedValue(Settings settings, MemBuffer buf) {
        Data data;
        if (settings instanceof Data && (data = (Data)settings).isDefined()) {
            return TranslationSettingsDefinition.TRANSLATION.getTranslatedValue(data);
        }
        return null;
    }

    private StringDataInstance(StringDataInstance copyFrom, StringLayoutEnum newLayout, MemBuffer newBuf, int newLen, String newCharsetName) {
        this.charSize = copyFrom.charSize;
        this.paddedCharSize = copyFrom.paddedCharSize;
        this.translatedValue = null;
        this.charsetName = newCharsetName;
        this.stringLayout = newLayout;
        this.showTranslation = false;
        this.renderSetting = copyFrom.renderSetting;
        this.length = newLen;
        this.buf = newBuf;
        this.endianSetting = copyFrom.endianSetting;
    }

    private static DataOrganization getDataOrganization(DataType dataType) {
        DataTypeManager dtm;
        if (dataType != null && (dtm = dataType.getDataTypeManager()) != null) {
            return dtm.getDataOrganization();
        }
        return DataOrganizationImpl.getDefaultOrganization();
    }

    private static StringLayoutEnum getLayoutFromDataType(DataType dataType) {
        if (dataType instanceof AbstractStringDataType) {
            return ((AbstractStringDataType)dataType).getStringLayout();
        }
        if (dataType instanceof AbstractIntegerDataType || dataType instanceof BitFieldDataType) {
            return StringLayoutEnum.CHAR_SEQ;
        }
        return StringLayoutEnum.NULL_TERMINATED_BOUNDED;
    }

    static String getCharsetNameFromDataTypeOrSettings(DataType dataType, Settings settings) {
        if (dataType instanceof BitFieldDataType) {
            dataType = ((BitFieldDataType)dataType).getBaseDataType();
        }
        return dataType instanceof DataTypeWithCharset ? ((DataTypeWithCharset)dataType).getCharsetName(settings) : DEFAULT_CHARSET_NAME;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Address getAddress() {
        return this.buf.getAddress();
    }

    public Address getEndAddress() {
        try {
            return this.length > 0 ? this.buf.getAddress().addNoWrap(this.length - 1) : this.buf.getAddress();
        }
        catch (AddressOverflowException e) {
            return this.buf.getAddress();
        }
    }

    public AddressRange getAddressRange() {
        return new AddressRangeImpl(this.getAddress(), this.getEndAddress());
    }

    private boolean isBadCharSize() {
        return this.paddedCharSize < 1 || this.paddedCharSize > 8 || this.charSize != 1 && this.charSize != 2 && this.charSize != 4 || this.paddedCharSize < this.charSize;
    }

    private boolean isProbe() {
        return this.length == -1;
    }

    private boolean isAlreadyDeterminedFixedLen() {
        return this.length >= 0 && this.stringLayout.isFixedLen();
    }

    public int getDataLength() {
        return this.length;
    }

    public int getStringLength() {
        if (this.stringLayout.isPascal()) {
            return this.getPascalLength();
        }
        if (this.isBadCharSize() || this.buf == null || this.isAlreadyDeterminedFixedLen()) {
            return this.length;
        }
        return this.getNullTerminatedLength();
    }

    private int getNullTerminatedLength() {
        int localLen = this.length;
        boolean localNT = this.stringLayout.isNullTerminated();
        if (this.isProbe() || this.stringLayout == StringLayoutEnum.NULL_TERMINATED_UNBOUNDED) {
            localLen = 16384;
            localNT = true;
        }
        int internalCharOffset = this.buf.isBigEndian() ? this.paddedCharSize - this.charSize : 0;
        byte[] charBuf = new byte[this.charSize];
        for (int offset = 0; offset < localLen; offset += this.paddedCharSize) {
            try {
                if (!this.readChar(charBuf, offset + internalCharOffset)) break;
                if (!localNT || !this.isNullChar(charBuf)) continue;
                return offset + this.paddedCharSize;
            }
            catch (AddressOutOfBoundsException exc) {
                return this.stringLayout == StringLayoutEnum.NULL_TERMINATED_UNBOUNDED ? -1 : offset;
            }
        }
        return this.stringLayout == StringLayoutEnum.NULL_TERMINATED_UNBOUNDED ? -1 : this.length;
    }

    public boolean isMissingNullTerminator() {
        if (this.stringLayout.shouldTrimTrailingNulls()) {
            String str = this.getStringValueNoTrim();
            return str != null && str.length() > 0 && str.charAt(str.length() - 1) != '\u0000';
        }
        return false;
    }

    private int getPascalLength() {
        try {
            switch (this.stringLayout) {
                case PASCAL_255: {
                    return 1 + this.buf.getUnsignedByte(0) * this.paddedCharSize;
                }
                case PASCAL_64k: {
                    return 2 + this.buf.getUnsignedShort(0) * this.paddedCharSize;
                }
            }
            return -1;
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("PascalString error: " + e.getMessage()));
            return -1;
        }
    }

    private boolean readChar(byte[] charBuf, int offset) {
        return this.buf.getBytes(charBuf, offset) == charBuf.length;
    }

    private boolean isNullChar(byte[] charBuf) {
        for (byte element : charBuf) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    public String getStringValue() {
        String str = this.getStringValueNoTrim();
        return str != null && this.stringLayout.shouldTrimTrailingNulls() ? this.trimNulls(str) : str;
    }

    private String getStringValueNoTrim() {
        if (this.isProbe() || this.isBadCharSize() || !this.buf.isInitializedMemory()) {
            return null;
        }
        byte[] stringBytes = this.convertPaddedToUnpadded(this.getStringBytes());
        if (stringBytes == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo(stringBytes);
        String str = this.convertBytesToString(stringBytes, aci);
        return str;
    }

    private byte[] getStringBytes() {
        return this.stringLayout.isPascal() ? this.getPascalCharBytes() : this.getNormalStringCharBytes();
    }

    private byte[] getNormalStringCharBytes() {
        int strLength = this.getStringLength();
        return this.getBytesFromMemBuff(this.buf, strLength >= 0 ? strLength : this.length);
    }

    private byte[] getPascalCharBytes() {
        try {
            int len;
            WrappedMemBuffer pascalBuf = new WrappedMemBuffer(this.buf, switch (this.stringLayout) {
                case StringLayoutEnum.PASCAL_255 -> {
                    len = this.buf.getUnsignedByte(0) * this.paddedCharSize;
                    yield 1;
                }
                case StringLayoutEnum.PASCAL_64k -> {
                    len = this.buf.getUnsignedShort(0) * this.paddedCharSize;
                    yield 2;
                }
                default -> throw new IllegalArgumentException();
            });
            return this.getBytesFromMemBuff(pascalBuf, len);
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("PascalString error: " + e.getMessage()));
            return null;
        }
    }

    private boolean isValidOffcutOffset(int offcutBytes) {
        switch (this.stringLayout) {
            case PASCAL_255: {
                int n = 1;
            }
            case PASCAL_64k: {
                int n = 2;
            }
        }
        int minValid = 0;
        return offcutBytes >= minValid && offcutBytes < this.length;
    }

    private int getCharOffset(int charCount) {
        int charBytes = charCount * this.charSize;
        switch (this.stringLayout) {
            case PASCAL_255: {
                return Math.max(0, 1 + charBytes);
            }
            case PASCAL_64k: {
                return Math.max(0, 2 + charBytes);
            }
        }
        return charBytes;
    }

    private StringLayoutEnum getOffcutLayout() {
        switch (this.stringLayout) {
            case PASCAL_255: 
            case PASCAL_64k: {
                return StringLayoutEnum.FIXED_LEN;
            }
        }
        return this.stringLayout;
    }

    private byte[] getBytesFromMemBuff(MemBuffer memBuffer, int copyLen) {
        byte[] bytes = new byte[copyLen = copyLen / this.paddedCharSize * this.paddedCharSize];
        if (memBuffer.getBytes(bytes, 0) != bytes.length) {
            return null;
        }
        return bytes;
    }

    private byte[] convertPaddedToUnpadded(byte[] paddedBytes) {
        if (this.paddedCharSize == this.charSize || paddedBytes == null) {
            return paddedBytes;
        }
        byte[] unpaddedBytes = new byte[paddedBytes.length / this.paddedCharSize * this.charSize];
        int srcOffset = this.buf.isBigEndian() ? this.paddedCharSize - this.charSize : 0;
        int destOffset = 0;
        while (srcOffset < paddedBytes.length) {
            System.arraycopy(paddedBytes, srcOffset, unpaddedBytes, destOffset, this.charSize);
            srcOffset += this.paddedCharSize;
            destOffset += this.charSize;
        }
        return unpaddedBytes;
    }

    private byte[] convertUnpaddedToPadded(byte[] unpaddedBytes) {
        int destOffset;
        if (this.paddedCharSize == this.charSize || unpaddedBytes == null) {
            return unpaddedBytes;
        }
        byte[] paddedBytes = new byte[unpaddedBytes.length / this.charSize * this.paddedCharSize];
        int srcOffset = 0;
        int n = destOffset = this.buf.isBigEndian() ? this.paddedCharSize - this.charSize : 0;
        while (srcOffset < unpaddedBytes.length) {
            System.arraycopy(unpaddedBytes, srcOffset, paddedBytes, destOffset, this.charSize);
            srcOffset += this.charSize;
            destOffset += this.paddedCharSize;
        }
        return paddedBytes;
    }

    private Endian getMemoryEndianness() {
        return this.buf.isBigEndian() ? Endian.BIG : Endian.LITTLE;
    }

    private String convertBytesToString(byte[] bytes, AdjustedCharsetInfo aci) {
        Charset cs = Charset.isSupported(aci.charsetName) ? Charset.forName(aci.charsetName) : null;
        return cs != null ? new String(bytes, aci.byteStartOffset, bytes.length - aci.byteStartOffset, cs) : StringDataInstance.convertBytesToStringCustomCharset(bytes, aci);
    }

    private AdjustedCharsetInfo getAdjustedCharsetInfo() {
        if (this.length == -1 && this.getStringLength() == -1) {
            return this.getAdjustedCharsetInfo(new byte[0]);
        }
        byte[] stringBytes = this.convertPaddedToUnpadded(this.getStringBytes());
        if (stringBytes == null) {
            return this.getAdjustedCharsetInfo(new byte[0]);
        }
        return this.getAdjustedCharsetInfo(stringBytes);
    }

    private AdjustedCharsetInfo getAdjustedCharsetInfo(byte[] bytes) {
        AdjustedCharsetInfo result = new AdjustedCharsetInfo(this.charsetName);
        if (CharsetInfo.isBOMCharset(this.charsetName)) {
            result.endian = StringDataInstance.getEndiannessFromBOM(bytes, this.charSize);
            if (result.endian != null) {
                result.byteStartOffset = this.charSize;
            }
            if (result.endian == null) {
                result.endian = this.endianSetting;
            }
            if (result.endian == null) {
                result.endian = this.getMemoryEndianness();
            }
            result.charsetName = result.charsetName + result.endian.toShortString();
        }
        if (result.endian == null) {
            result.endian = this.getMemoryEndianness();
        }
        return result;
    }

    private static DataConverter getDataConverter(Endian endian) {
        return endian == Endian.BIG ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
    }

    private static String convertBytesToStringCustomCharset(byte[] bytes, AdjustedCharsetInfo aci) {
        switch (aci.charsetName) {
            case "UTF-32LE": 
            case "UTF-32BE": {
                DataConverter dc = StringDataInstance.getDataConverter(aci.endian);
                int[] codePoints = new int[(bytes.length - aci.byteStartOffset) / 4];
                for (int i = 0; i < codePoints.length; ++i) {
                    codePoints[i] = dc.getInt(bytes, aci.byteStartOffset + i * 4);
                    if (codePoints[i] >= 0 && codePoints[i] <= 0x10FFFF) continue;
                    codePoints[i] = 65533;
                }
                return new String(codePoints, 0, codePoints.length);
            }
        }
        return null;
    }

    private static Endian getEndiannessFromBOM(byte[] bytes, int charSize) {
        if (bytes.length < charSize) {
            return null;
        }
        int be_val = (int)BigEndianDataConverter.INSTANCE.getValue(bytes, charSize);
        switch (be_val) {
            case 65279: {
                return Endian.BIG;
            }
            case -131072: 
            case 65534: {
                return Endian.LITTLE;
            }
        }
        return null;
    }

    public String getStringRepresentation() {
        return this.showTranslation && this.translatedValue != null ? StringDataInstance.getTranslatedStringRepresentation(this.translatedValue) : this.getStringRep('\"', '\"');
    }

    public String getStringRepresentation(boolean originalOrTranslated) {
        return originalOrTranslated ? this.getStringRep('\"', '\"') : (this.translatedValue != null ? StringDataInstance.getTranslatedStringRepresentation(this.translatedValue) : UNKNOWN);
    }

    private String getStringRep(char quoteChar, char quoteCharMulti) {
        int codePoint;
        if (this.isProbe() || this.isBadCharSize() || !this.buf.isInitializedMemory()) {
            return UNKNOWN;
        }
        byte[] stringBytes = this.convertPaddedToUnpadded(this.getStringBytes());
        if (stringBytes == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo(stringBytes);
        String stringValue = this.convertBytesToString(stringBytes, aci);
        if (stringValue == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        if (stringValue.length() == 0 && aci.byteStartOffset != 0) {
            stringValue = BOM_RESULT_STR;
        }
        boolean isByteToStringCharEquiv = stringValue.length() == (stringBytes.length - aci.byteStartOffset) / this.charSize;
        stringValue = this.stringLayout.shouldTrimTrailingNulls() ? this.trimNulls(stringValue) : stringValue;
        StringRenderBuilder strBuf = new StringRenderBuilder(this.charSize, stringValue.length() == 1 ? quoteChar : quoteCharMulti);
        if (stringValue.isEmpty() || stringValue.length() == 1 && stringValue.charAt(0) == '\u0000') {
            strBuf.addString("");
        }
        int strLength = stringValue.length();
        block10: for (int i = 0; i < strLength; i += Character.charCount(codePoint)) {
            codePoint = stringValue.codePointAt(i);
            RenderUnicodeSettingsDefinition.RENDER_ENUM currentCharRenderSetting = this.renderSetting;
            if (codePoint == 65533 && isByteToStringCharEquiv && !this.isReplacementCharAt(stringBytes, i * this.charSize + aci.byteStartOffset)) {
                currentCharRenderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ;
            }
            if (StringUtilities.isControlCharacterOrBackslash((int)codePoint)) {
                strBuf.addString(StringUtilities.convertCodePointToEscapeSequence((int)codePoint));
                continue;
            }
            if (codePoint == 0 && this.renderSetting != RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ) {
                strBuf.addEscapedChar('0');
                continue;
            }
            if (StringUtilities.isDisplayable((int)codePoint)) {
                strBuf.addCodePointChar(codePoint);
                continue;
            }
            if (currentCharRenderSetting == RenderUnicodeSettingsDefinition.RENDER_ENUM.ALL) {
                if (codePoint <= 127) {
                    currentCharRenderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ;
                } else if (Character.isISOControl(codePoint) || !Character.isDefined(codePoint) || codePoint == 65279) {
                    currentCharRenderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.ESC_SEQ;
                }
            }
            switch (currentCharRenderSetting) {
                case ALL: {
                    strBuf.addCodePointChar(codePoint);
                    continue block10;
                }
                case BYTE_SEQ: {
                    strBuf.addByteSeq(this.getOriginalBytes(isByteToStringCharEquiv, i, codePoint, stringBytes, aci));
                    continue block10;
                }
                case ESC_SEQ: {
                    strBuf.addEscapedCodePoint(codePoint);
                }
            }
        }
        String prefix = "";
        if (this.charsetName.startsWith("UTF") && strBuf.startsWithQuotedText()) {
            switch (this.charSize) {
                case 1: {
                    prefix = "u8";
                    break;
                }
                case 2: {
                    prefix = "u";
                    break;
                }
                case 4: {
                    prefix = "U";
                }
            }
        }
        return prefix + strBuf.toString();
    }

    private byte[] getOriginalBytes(boolean isByteToStringCharEquiv, int charOffset, int codePoint, byte[] stringBytes, AdjustedCharsetInfo aci) {
        Charset cs;
        if (isByteToStringCharEquiv) {
            byte[] originalCharBytes = new byte[this.charSize];
            System.arraycopy(stringBytes, charOffset * this.charSize + aci.byteStartOffset, originalCharBytes, 0, this.charSize);
            return originalCharBytes;
        }
        String singleCharStr = new String(new int[]{codePoint}, 0, 1);
        Charset charset = cs = Charset.isSupported(aci.charsetName) ? Charset.forName(aci.charsetName) : null;
        if (cs == null || !cs.canEncode()) {
            return null;
        }
        return singleCharStr.getBytes(cs);
    }

    private String trimNulls(String s) {
        int lastGoodChar;
        for (lastGoodChar = s.length() - 1; lastGoodChar >= 0 && s.charAt(lastGoodChar) == '\u0000'; --lastGoodChar) {
        }
        return s.substring(0, lastGoodChar + 1);
    }

    public boolean hasTranslatedValue() {
        return this.translatedValue != null;
    }

    public String getTranslatedValue() {
        return this.translatedValue;
    }

    public boolean isShowTranslation() {
        return this.showTranslation;
    }

    public String getCharRepresentation() {
        if (this.length < this.charSize) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        String newCSName = this.length < this.charSize ? DEFAULT_CHARSET_NAME : this.charsetName;
        StringDataInstance charseqSDI = new StringDataInstance(this, StringLayoutEnum.CHAR_SEQ, this.buf, this.length, newCSName);
        return charseqSDI.getStringRep('\'', '\"');
    }

    private boolean isReplacementCharAt(byte[] stringBytes, int byteOffset) {
        if (byteOffset + this.charSize > stringBytes.length) {
            return false;
        }
        long origCodePointValue = DataConverter.getInstance((boolean)this.buf.isBigEndian()).getValue(stringBytes, byteOffset, this.charSize);
        return origCodePointValue == 65533L;
    }

    private static String getTranslatedStringRepresentation(String translatedString) {
        return "\u00bb" + translatedString + "\u00ab";
    }

    public String getLabel(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options) {
        if (this.isProbe() || this.isBadCharSize()) {
            return defaultStr;
        }
        if (options.useAbbreviatedForm()) {
            return abbrevPrefixStr;
        }
        String str = this.getStringValue();
        if (str == null) {
            return defaultStr;
        }
        if (str.length() == 0) {
            return prefixStr;
        }
        return StringDataInstance.makeStringLabel(prefixStr, str, options);
    }

    public String getOffcutLabelString(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options, int byteOffset) {
        if (this.isBadCharSize() || this.isProbe()) {
            return defaultStr;
        }
        StringDataInstance sub = this.getByteOffcut(byteOffset);
        return sub.getLabel(prefixStr, abbrevPrefixStr, defaultStr, options);
    }

    public StringDataInstance getByteOffcut(int byteOffset) {
        if (this.isBadCharSize() || this.isProbe() || !this.isValidOffcutOffset(byteOffset)) {
            return NULL_INSTANCE;
        }
        if (byteOffset == 0) {
            return this;
        }
        int newLength = Math.max(0, this.length - byteOffset);
        StringDataInstance sub = new StringDataInstance(this, this.getOffcutLayout(), (MemBuffer)new WrappedMemBuffer(this.buf, byteOffset), newLength, this.charsetName);
        return sub;
    }

    public StringDataInstance getCharOffcut(int offsetChars) {
        return this.getByteOffcut(this.getCharOffset(offsetChars));
    }

    public DataType getStringDataTypeGuess() {
        DataType result = dataTypeMap.get(new Pair((Object)this.stringLayout, (Object)this.charsetName));
        if (result == null) {
            result = dataTypeMap.get(new Pair((Object)this.stringLayout, null));
        }
        if (result == null) {
            result = StringDataType.dataType;
        }
        return result;
    }

    public String toString() {
        return this.getStringValue();
    }

    private static ByteBuffer allocBuf(MemBuffer buf, int length) {
        return ByteBuffer.allocate(length).order(buf.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    private static boolean fitsIn(ByteBuffer buf, int lenLen) {
        return buf.limit() < 1 << 8 * lenLen;
    }

    public byte[] encodeReplacementFromStringValue(CharSequence value) throws CharacterCodingException {
        CharsetEncoder ce = Charset.forName(this.charsetName).newEncoder();
        ByteBuffer bb = ce.encode(CharBuffer.wrap(value));
        return this.convertUnpaddedToPadded(this.checkAndEncodeLayout(bb));
    }

    public byte[] encodeReplacementFromStringRepresentation(CharSequence repr) throws MalformedInputException, UnmappableCharacterException, StringRenderParser.StringParseException {
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo();
        StringRenderParser parser = new StringRenderParser('\"', aci.endian, aci.charsetName, aci.byteStartOffset != 0);
        ByteBuffer bb = parser.parse(CharBuffer.wrap(repr));
        return this.convertUnpaddedToPadded(this.checkAndEncodeLayout(bb));
    }

    public byte[] encodeReplacementFromCharValue(char[] value) throws CharacterCodingException {
        CharsetEncoder ce = Charset.forName(this.charsetName).newEncoder();
        ByteBuffer bb = ce.encode(CharBuffer.wrap(value));
        return Arrays.copyOf(bb.array(), bb.limit());
    }

    public byte[] encodeReplacementFromCharRepresentation(CharSequence repr) throws MalformedInputException, UnmappableCharacterException, StringRenderParser.StringParseException {
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo();
        StringRenderParser parser = new StringRenderParser('\'', aci.endian, aci.charsetName, aci.byteStartOffset != 0);
        ByteBuffer bb = parser.parse(CharBuffer.wrap(repr));
        return Arrays.copyOf(bb.array(), bb.limit());
    }

    private byte[] checkAndEncodeLayout(ByteBuffer encoded) {
        switch (this.stringLayout) {
            case CHAR_SEQ: 
            case FIXED_LEN: {
                if (this.length != -1 && encoded.limit() > this.length) {
                    throw new IllegalArgumentException("Encoded string does not fit");
                }
                byte[] result = new byte[this.length != -1 ? this.length : encoded.limit()];
                encoded.get(result, 0, encoded.limit());
                return result;
            }
            case NULL_TERMINATED_BOUNDED: {
                if (this.length != -1 && encoded.limit() + this.charSize > this.length) {
                    throw new IllegalArgumentException("Encoded string does not fit");
                }
                byte[] result = new byte[encoded.limit() + this.charSize];
                encoded.get(result, 0, encoded.limit());
                return result;
            }
            case NULL_TERMINATED_UNBOUNDED: {
                byte[] result = new byte[encoded.limit() + this.charSize];
                encoded.get(result, 0, encoded.limit());
                return result;
            }
            case PASCAL_255: {
                if (!StringDataInstance.fitsIn(encoded, 1)) {
                    throw new IllegalArgumentException("Encoded string does not fit");
                }
                ByteBuffer result = StringDataInstance.allocBuf(this.buf, encoded.limit() + 1);
                result.put((byte)encoded.limit());
                result.put(encoded);
                return result.array();
            }
            case PASCAL_64k: {
                if (!StringDataInstance.fitsIn(encoded, 2)) {
                    throw new IllegalArgumentException("Encoded string does not fit");
                }
                ByteBuffer result = StringDataInstance.allocBuf(this.buf, encoded.limit() + 2);
                result.putShort((short)encoded.limit());
                result.put(encoded);
                return result.array();
            }
        }
        throw new IllegalArgumentException("Unknown string layout");
    }

    static {
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.PASCAL_255, null), PascalString255DataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.PASCAL_64k, null), PascalStringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, null), StringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_BOUNDED, null), StringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_UNBOUNDED, null), TerminatedStringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.PASCAL_64k, (Object)"UTF-16"), PascalUnicodeDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, (Object)"UTF-8"), StringUTF8DataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, (Object)"UTF-16"), UnicodeDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, (Object)"UTF-32"), Unicode32DataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_UNBOUNDED, (Object)"UTF-16"), TerminatedUnicodeDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_UNBOUNDED, (Object)"UTF-32"), TerminatedUnicode32DataType.dataType);
    }

    private static class AdjustedCharsetInfo {
        String charsetName;
        int byteStartOffset;
        Endian endian;

        public AdjustedCharsetInfo(String charsetName) {
            this.charsetName = charsetName;
        }
    }

    public static class StaticStringInstance
    extends StringDataInstance {
        private final String fakeStr;
        private final int fakeLen;

        public StaticStringInstance(String fakeStr, int fakeLen) {
            this.fakeStr = fakeStr;
            this.fakeLen = fakeLen;
        }

        @Override
        public String getStringValue() {
            return this.fakeStr;
        }

        @Override
        public String getStringRepresentation() {
            return this.fakeStr;
        }

        @Override
        public int getStringLength() {
            return this.fakeLen;
        }

        @Override
        public String getLabel(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options) {
            return defaultStr;
        }

        @Override
        public String getOffcutLabelString(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options, int offcutOffset) {
            return defaultStr;
        }
    }
}

