/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.protorules.HomogeneousAggregate;
import ghidra.program.model.lang.protorules.MetaTypeFilter;
import ghidra.program.model.lang.protorules.SizeRestrictedFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public interface DatatypeFilter {
    public DatatypeFilter clone();

    public boolean isEquivalent(DatatypeFilter var1);

    public boolean filter(DataType var1);

    public void encode(Encoder var1) throws IOException;

    public void restoreXml(XmlPullParser var1) throws XmlParseException;

    public static boolean extractPrimitives(DataType dt, int max, ArrayList<DataType> res) {
        DataTypeComponent[] components;
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        int metaType = PcodeDataTypeManager.getMetatype(dt);
        switch (metaType) {
            case 12: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (res.size() >= max) {
                    return false;
                }
                res.add(dt);
                return true;
            }
            case 4: {
                int numEls = ((Array)dt).getNumElements();
                DataType base = ((Array)dt).getDataType();
                for (int i = 0; i < numEls; ++i) {
                    if (DatatypeFilter.extractPrimitives(base, max, res)) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        Structure structPtr = (Structure)dt;
        boolean isPacked = structPtr.isPackingEnabled();
        int curOff = 0;
        for (DataTypeComponent component : components = structPtr.getDefinedComponents()) {
            DataType compDT = component.getDataType();
            if (!isPacked) {
                int nextOff = component.getOffset();
                int align = dt.getAlignment();
                int rem = curOff % align;
                if (rem != 0) {
                    curOff += align - rem;
                }
                if (curOff != nextOff) {
                    return false;
                }
                curOff = nextOff + compDT.getAlignedLength();
            }
            if (DatatypeFilter.extractPrimitives(compDT, max, res)) continue;
            return false;
        }
        return true;
    }

    public static DatatypeFilter restoreFilterXml(XmlPullParser parser) throws XmlParseException {
        SizeRestrictedFilter filter;
        XmlElement elemId = parser.peek();
        String nm = elemId.getAttribute(AttributeId.ATTRIB_NAME.name());
        if (nm.equals("any")) {
            filter = new SizeRestrictedFilter();
        } else if (nm.equals("homogeneous-float-aggregate")) {
            filter = new HomogeneousAggregate("homogeneous-float-aggregate", 7, 4, 0, 0);
        } else {
            int meta = PcodeDataTypeManager.getMetatype(nm);
            filter = new MetaTypeFilter(meta);
        }
        filter.restoreXml(parser);
        return filter;
    }
}

