/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParamListStandardOut;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MultiSlotAssign
extends AssignAction {
    private StorageClass resourceType;
    private boolean consumeFromStack;
    private boolean consumeMostSig;
    private boolean enforceAlignment;
    private boolean justifyRight;
    private ParamEntry stackEntry;
    private int firstIter;

    private void initializeEntries() throws InvalidInputException {
        this.firstIter = -1;
        for (int i = 0; i < this.resource.getNumParamEntry(); ++i) {
            ParamEntry entry = this.resource.getEntry(i);
            if (this.firstIter == -1 && entry.isExclusion() && entry.getType() == this.resourceType && entry.getAllGroups().length == 1) {
                this.firstIter = i;
            }
            if (entry.isExclusion() || !entry.getSpace().isStackSpace()) continue;
            this.stackEntry = entry;
            break;
        }
        if (this.firstIter == -1) {
            throw new InvalidInputException("Could not find matching resources for action: join");
        }
        if (this.consumeFromStack && this.stackEntry == null) {
            throw new InvalidInputException("Cannot find matching <pentry> for action: join");
        }
    }

    protected MultiSlotAssign(ParamListStandard res) {
        super(res);
        this.resourceType = StorageClass.GENERAL;
        this.consumeFromStack = !(res instanceof ParamListStandardOut);
        this.consumeMostSig = false;
        this.enforceAlignment = false;
        this.justifyRight = false;
        if (res.getEntry(0).isBigEndian()) {
            this.consumeMostSig = true;
            this.justifyRight = true;
        }
        this.stackEntry = null;
    }

    public MultiSlotAssign(StorageClass store, boolean stack, boolean mostSig, boolean align, boolean justRight, ParamListStandard res) throws InvalidInputException {
        super(res);
        this.resourceType = store;
        this.consumeFromStack = stack;
        this.consumeMostSig = mostSig;
        this.enforceAlignment = align;
        this.justifyRight = justRight;
        this.stackEntry = null;
        this.initializeEntries();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new MultiSlotAssign(this.resourceType, this.consumeFromStack, this.consumeMostSig, this.enforceAlignment, this.justifyRight, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        MultiSlotAssign otherAction = (MultiSlotAssign)op;
        if (this.consumeFromStack != otherAction.consumeFromStack || this.consumeMostSig != otherAction.consumeMostSig || this.enforceAlignment != otherAction.enforceAlignment) {
            return false;
        }
        if (this.firstIter != otherAction.firstIter || this.justifyRight != otherAction.justifyRight) {
            return false;
        }
        if (this.resourceType != otherAction.resourceType) {
            return false;
        }
        if (this.stackEntry != null || otherAction.stackEntry != null) {
            if (this.stackEntry != null && otherAction.stackEntry != null) {
                if (!this.stackEntry.isEquivalent(otherAction.stackEntry)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        int iter;
        int[] tmpStatus = (int[])status.clone();
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        ParameterPieces param = new ParameterPieces();
        int sizeLeft = dt.getLength();
        int endIter = this.resource.getNumParamEntry();
        if (this.enforceAlignment) {
            ParamEntry entry;
            int resourcesConsumed = 0;
            for (iter = this.firstIter; iter != endIter && (entry = this.resource.getEntry(iter)).isExclusion(); ++iter) {
                if (entry.getType() != this.resourceType || entry.getAllGroups().length != 1) continue;
                if (tmpStatus[entry.getGroup()] == 0) {
                    int regSize;
                    int align = dt.getAlignment();
                    if (align <= (regSize = entry.getSize()) || resourcesConsumed % align == 0) break;
                    tmpStatus[entry.getGroup()] = -1;
                }
                resourcesConsumed += entry.getSize();
            }
        }
        while (sizeLeft > 0 && iter != endIter) {
            ParamEntry entry = this.resource.getEntry(iter);
            ++iter;
            if (!entry.isExclusion()) break;
            if (entry.getType() != this.resourceType || entry.getAllGroups().length != 1 || tmpStatus[entry.getGroup()] != 0) continue;
            int trialSize = entry.getSize();
            entry.getAddrBySlot(tmpStatus[entry.getGroup()], trialSize, 1, param);
            tmpStatus[entry.getGroup()] = -1;
            Varnode vn = new Varnode(param.address, trialSize);
            pieces.add(vn);
            sizeLeft -= trialSize;
        }
        boolean onePieceJoin = false;
        if (sizeLeft > 0) {
            if (!this.consumeFromStack) {
                return 1;
            }
            int grp = this.stackEntry.getGroup();
            tmpStatus[grp] = this.stackEntry.getAddrBySlot(tmpStatus[grp], sizeLeft, 1, param);
            if (param.address == null) {
                return 1;
            }
            Varnode vn = new Varnode(param.address, sizeLeft);
            pieces.add(vn);
        } else if (sizeLeft < 0) {
            if (this.resourceType == StorageClass.FLOAT && pieces.size() == 1) {
                onePieceJoin = true;
            } else if (this.justifyRight) {
                Varnode vn = (Varnode)pieces.get(0);
                Address addr = vn.getAddress().add(-sizeLeft);
                sz = vn.getSize() + sizeLeft;
                vn = new Varnode(addr, sz);
                pieces.set(0, vn);
            } else {
                int end = pieces.size() - 1;
                Varnode vn = (Varnode)pieces.get(end);
                sz = vn.getSize() + sizeLeft;
                vn = new Varnode(vn.getAddress(), sz);
                pieces.set(end, vn);
            }
        }
        System.arraycopy(tmpStatus, 0, status, 0, tmpStatus.length);
        res.type = dt;
        if (pieces.size() == 1 && !onePieceJoin) {
            res.address = ((Varnode)pieces.get(0)).getAddress();
            return 0;
        }
        res.joinPieces = new Varnode[pieces.size()];
        if (!this.consumeMostSig) {
            for (int i = 0; i < res.joinPieces.length; ++i) {
                res.joinPieces[i] = (Varnode)pieces.get(pieces.size() - 1 - i);
            }
        } else {
            for (int i = 0; i < pieces.size(); ++i) {
                res.joinPieces[i] = (Varnode)pieces.get(i);
            }
        }
        res.address = Address.NO_ADDRESS;
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_JOIN);
        if (this.resource.getEntry(0).isBigEndian() != this.justifyRight) {
            encoder.writeBool(AttributeId.ATTRIB_REVERSEJUSTIFY, true);
        }
        if (this.resourceType != StorageClass.GENERAL) {
            encoder.writeString(AttributeId.ATTRIB_STORAGE, this.resourceType.toString());
        }
        encoder.writeBool(AttributeId.ATTRIB_ALIGN, this.enforceAlignment);
        encoder.closeElement(ElementId.ELEM_JOIN);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_JOIN.name()});
        for (Map.Entry attrib : elem.getAttributes().entrySet()) {
            String name = (String)attrib.getKey();
            if (name.equals(AttributeId.ATTRIB_REVERSEJUSTIFY.name())) {
                if (!SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()))) continue;
                this.justifyRight = !this.justifyRight;
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_STORAGE.name())) {
                this.resourceType = StorageClass.getClass((String)attrib.getValue());
                continue;
            }
            if (!name.equals(AttributeId.ATTRIB_ALIGN.name())) continue;
            this.enforceAlignment = SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()));
        }
        parser.end(elem);
        try {
            this.initializeEntries();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

