/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionShellSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.util.HashMap;
import java.util.Iterator;

public class GlobalSymbolMap {
    private Program program;
    private HighFunction func;
    private SymbolTable symbolTable;
    private HashMap<Address, HighSymbol> addrMappedSymbols;
    private HashMap<Long, HighSymbol> symbolMap;
    private long uniqueSymbolId;

    public GlobalSymbolMap(HighFunction f) {
        this.program = f.getFunction().getProgram();
        this.func = f;
        this.symbolTable = this.program.getSymbolTable();
        this.addrMappedSymbols = new HashMap();
        this.symbolMap = new HashMap();
        this.uniqueSymbolId = 0L;
    }

    private void insertSymbol(HighSymbol sym, Address addr) {
        long val;
        long uniqueId = sym.getId();
        if (uniqueId >> 56 == 64L && (val = uniqueId & Integer.MAX_VALUE) > this.uniqueSymbolId) {
            this.uniqueSymbolId = val;
        }
        this.symbolMap.put(uniqueId, sym);
        this.addrMappedSymbols.put(addr, sym);
    }

    public HighSymbol populateSymbol(long id, DataType dataType, int sz) {
        if (id >> 56 == 64L) {
            return null;
        }
        Symbol symbol = this.symbolTable.getSymbol(id);
        if (symbol == null) {
            return null;
        }
        HighSymbol highSym = null;
        if (symbol instanceof CodeSymbol) {
            if (dataType == null) {
                Object dataObj = symbol.getObject();
                if (dataObj instanceof Data) {
                    dataType = ((Data)dataObj).getDataType();
                    sz = dataType.getLength();
                } else {
                    dataType = DataType.DEFAULT;
                    sz = 1;
                }
            }
            highSym = new HighCodeSymbol((CodeSymbol)symbol, dataType, sz, this.func);
        } else if (symbol instanceof FunctionSymbol) {
            highSym = new HighFunctionShellSymbol(id, symbol.getName(), symbol.getAddress(), this.func.getDataTypeManager());
        } else {
            return null;
        }
        this.insertSymbol(highSym, symbol.getAddress());
        return highSym;
    }

    public void populateAnnotation(Varnode vn) {
        HighSymbol highSym;
        Address addr = vn.getAddress();
        if (!addr.isLoadedMemoryAddress() || this.addrMappedSymbols.containsKey(addr)) {
            return;
        }
        Symbol symbol = this.symbolTable.getPrimarySymbol(addr);
        if (symbol == null) {
            return;
        }
        if (symbol instanceof CodeSymbol) {
            Data dataAt = this.program.getListing().getDataAt(addr);
            DataType dataType = DataType.DEFAULT;
            int sz = 1;
            if (dataAt != null) {
                dataType = dataAt.getDataType();
                sz = dataAt.getLength();
            }
            highSym = new HighCodeSymbol((CodeSymbol)symbol, dataType, sz, this.func);
        } else if (symbol instanceof FunctionSymbol) {
            highSym = new HighFunctionShellSymbol(symbol.getID(), symbol.getName(), symbol.getAddress(), this.func.getDataTypeManager());
        } else {
            return;
        }
        this.insertSymbol(highSym, symbol.getAddress());
    }

    public HighCodeSymbol newSymbol(long id, Address addr, DataType dataType, int sz) {
        if (dataType == null) {
            dataType = DataType.DEFAULT;
            sz = 1;
        }
        HighCodeSymbol symbol = new HighCodeSymbol(id, addr, dataType, sz, this.func);
        this.insertSymbol(symbol, addr);
        return symbol;
    }

    public HighSymbol getSymbol(long id) {
        return this.symbolMap.get(id);
    }

    public HighSymbol getSymbol(Address addr) {
        return this.addrMappedSymbols.get(addr);
    }

    public Iterator<HighSymbol> getSymbols() {
        return this.symbolMap.values().iterator();
    }
}

