/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.PrintStream;

public class SourceFileIndexer {
    private BiMap<String, Integer> filenameToIndex = HashBiMap.create();
    private int leastUnusedIndex = 0;

    public Integer index(Location loc) {
        if (loc == null) {
            Msg.info((Object)this, (Object)"null Location");
            return null;
        }
        String filename = loc.filename;
        if (filename == null) {
            Msg.info((Object)this, (Object)"null filename");
            return null;
        }
        Integer res = (Integer)this.filenameToIndex.putIfAbsent((Object)filename, (Object)this.leastUnusedIndex);
        if (res == null) {
            return this.leastUnusedIndex++;
        }
        return res;
    }

    public Integer getIndex(String filename) {
        return (Integer)this.filenameToIndex.get((Object)filename);
    }

    public String getFileName(Integer index) {
        return (String)this.filenameToIndex.inverse().get((Object)index);
    }

    public void saveXml(PrintStream s) {
        s.append("<sourcefiles>\n");
        for (int i = 0; i < this.leastUnusedIndex; ++i) {
            s.append("<sourcefile name=\"");
            XmlUtils.xml_escape(s, (String)this.filenameToIndex.inverse().get((Object)i));
            s.append("\" index=\"" + i + "\"/>\n");
        }
        s.append("</sourcefiles>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        XmlElement elem = parser.start(new String[]{"sourcefiles"});
        XmlElement subElem = null;
        while ((subElem = parser.softStart(new String[]{"sourcefile"})) != null) {
            String filename = subElem.getAttribute("name");
            Integer index = Integer.parseInt(subElem.getAttribute("index"));
            this.filenameToIndex.put((Object)filename, (Object)index);
            parser.end(subElem);
        }
        parser.end(elem);
    }
}

