/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.AddMemoryParameterCommand;
import ghidra.app.cmd.function.SetFunctionNameCmd;
import ghidra.app.cmd.function.SetFunctionVarArgsCommand;
import ghidra.app.cmd.function.SetReturnDataTypeCmd;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.SignedQWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class eBPFAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "eBPF";

    public eBPFAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
    }

    public AddressSet flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor, this.trustWriteMemOption);
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        BookmarkManager bmmanager = program.getBookmarkManager();
        bmmanager.removeBookmarks("Error", "Bad Instruction", monitor);
        SymbolTable table = program.getSymbolTable();
        boolean includeDynamicSymbols = true;
        SymbolIterator symbols = table.getAllSymbols(includeDynamicSymbols);
        for (Symbol s : symbols) {
            if (!s.getName().contains("syscall")) continue;
            Function func = program.getFunctionManager().getFunctionAt(s.getAddress());
            StructureDataType dstruct = null;
            VoidDataType dvoid = new VoidDataType();
            IntegerDataType dint = new IntegerDataType();
            CharDataType dchar = new CharDataType();
            UnsignedIntegerDataType duint = new UnsignedIntegerDataType();
            UnsignedLongDataType dulong = new UnsignedLongDataType();
            UnsignedShortDataType dushort = new UnsignedShortDataType();
            SignedQWordDataType dslong = new SignedQWordDataType();
            UnsignedCharDataType duchar = new UnsignedCharDataType();
            PointerDataType dvp = new PointerDataType((DataType)dvoid, 0);
            PointerDataType dcp = new PointerDataType((DataType)dchar, 0);
            SetFunctionVarArgsCommand cmdVar = new SetFunctionVarArgsCommand(func, true);
            String location = s.getName().substring(14);
            int helper_id = Integer.parseInt(location, 16);
            switch (helper_id) {
                case 0: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_unspec", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dvoid, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 1: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_map_lookup_elem", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dvp, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)dvp, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 2: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_map_update_elem", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)dvp, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "value", (DataType)dvp, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 3: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_map_delete_elem", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)dvp, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 4: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_probe_read", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "dst", (DataType)dvp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "src", (DataType)dvp, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 5: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_ktime_get_ns", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 6: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_trace_printk", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "fmt", (DataType)dcp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "fmt_size", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 7: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_prandom_u32", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)duint, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 8: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_smp_processor_id", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)duint, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 9: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_store_bytes", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdVar.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 10: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_l3_csum_replace", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "offset", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "from", (DataType)dulong, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "to", (DataType)dulong, 3, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg5 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)dulong, 4, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    cmdArg5.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 11: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_l4_csum_replace", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "offset", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "from", (DataType)dulong, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "to", (DataType)dulong, 3, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg5 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 4, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    cmdArg5.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 12: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_tail_call", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ctx", (DataType)dvp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "prog_array_map", (DataType)dsp, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "index", (DataType)duint, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 13: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_clone_redirect", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "ifindex", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 14: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_current_pid_tgid", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 15: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_current_uid_gid", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 16: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_current_comm", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "buf", (DataType)dcp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "size_of_buf", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 17: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_cgroup_classid", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)duint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 18: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_vlan_push", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "vlan_proto", (DataType)dushort, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "vlan_tci", (DataType)dushort, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 19: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_vlan_pop", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 20: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_get_tunnel_key", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_tunnel_key", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)duint, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 21: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_set_tunnel_key", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_tunnel_key", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)duint, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 22: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_perf_event_read", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 23: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_redirect", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ifindex", (DataType)duint, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 24: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_route_realm", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)duint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 25: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_perf_event_output", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct pt_reg", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ctx", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "data", (DataType)dvp, 3, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg5 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)dulong, 4, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    cmdArg5.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 26: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_load_bytes", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "offset", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "to", (DataType)dvp, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "len", (DataType)duint, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 27: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_stackid", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct pt_reg", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ctx", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 28: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_csum_diff", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dslong, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "from", (DataType)new PointerDataType((DataType)duint, 0), 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "from_size", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "to", (DataType)new PointerDataType((DataType)duint, 0), 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "to_size", (DataType)duint, 3, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg5 = new AddMemoryParameterCommand(func, s.getAddress(), "seed", (DataType)duint, 4, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    cmdArg5.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 29: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_get_tunnel_opt", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "opt", (DataType)new PointerDataType((DataType)duchar, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)duint, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 30: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_set_tunnel_opt", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "opt", (DataType)new PointerDataType((DataType)duchar, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)duint, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 31: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_change_proto", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "proto", (DataType)dushort, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 32: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_change_type", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "type", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 33: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_under_cgroup", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "index", (DataType)duint, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 34: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_hash_recalc", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)duint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 35: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_current_task", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 36: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_probe_write_user", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "dst", (DataType)dvp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "src", (DataType)dvp, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "len", (DataType)duint, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 37: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_current_task_under_cgroup", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "index", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 38: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_change_tail", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "len", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 39: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_pull_data", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "len", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 40: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_csum_update", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dslong, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "csum", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 41: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_set_hash_invalid", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dvoid, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 42: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_numa_node_id", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 43: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_change_head", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "len", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 44: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_xdp_adjust_head", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct xdp_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "xdp_md", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "delta", (DataType)dint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 45: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_probe_read_str", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct xdp_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "dst", (DataType)dvp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "size", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "unsafe_ptr", (DataType)dvp, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 46: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_socket_cookie", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 47: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_socket_cookie", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_sock_addr", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ctx", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 48: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_socket_cookie", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dulong, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_sock_ops", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ctx", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 49: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_get_socket_uid", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)duint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 50: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_set_hash", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "hash", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 51: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_setsockopt", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdVar.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 52: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_skb_adjust_room", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "len_diff", (DataType)dint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "mode", (DataType)duint, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 53: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_redirect_map", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)duint, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 54: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_sk_redirect_map", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skb", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)duint, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 55: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_sock_map_update", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_sock_ops", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "skops", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)dvp, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 56: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_xdp_adjust_meta", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct xdp_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "xdp_md", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "delta", (DataType)dint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 57: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_perf_event_read_value", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_map", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_perf_event_value", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "buf", (DataType)new PointerDataType((DataType)dstruct2, 0), 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "buf_size", (DataType)duint, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 58: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_perf_prog_read_value", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_perf_event_data", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_perf_event_value", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "ctx", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "buf", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "buf_size", (DataType)duint, 2, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 59: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_getsockopt", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdVar.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 60: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_override_return", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct pt_regs", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "regs", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "rc", (DataType)dulong, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 61: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_sock_ops_cb_flags_set", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct bpf_sock_ops", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "bpf_sock", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "argval", (DataType)dint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 62: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_msg_redirect_map", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_msg_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    StructureDataType dstruct2 = new StructureDataType("struct bpf_map", 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "msg", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "map", (DataType)new PointerDataType((DataType)dstruct2, 0), 1, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg3 = new AddMemoryParameterCommand(func, s.getAddress(), "key", (DataType)duint, 2, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg4 = new AddMemoryParameterCommand(func, s.getAddress(), "flags", (DataType)dulong, 3, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    cmdArg3.applyTo((DomainObject)program);
                    cmdArg4.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                case 63: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_msg_apply_bytes", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dint, SourceType.ANALYSIS);
                    dstruct = new StructureDataType("struct sk_msg_buff", 0);
                    PointerDataType dsp = new PointerDataType((DataType)dstruct, 0);
                    AddMemoryParameterCommand cmdArg1 = new AddMemoryParameterCommand(func, s.getAddress(), "msg", (DataType)dsp, 0, SourceType.ANALYSIS);
                    AddMemoryParameterCommand cmdArg2 = new AddMemoryParameterCommand(func, s.getAddress(), "bytes", (DataType)duint, 1, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    cmdArg1.applyTo((DomainObject)program);
                    cmdArg2.applyTo((DomainObject)program);
                    program.flushEvents();
                    break;
                }
                default: {
                    SetFunctionNameCmd cmdName = new SetFunctionNameCmd(s.getAddress(), "bpf_undef", SourceType.ANALYSIS);
                    SetReturnDataTypeCmd cmdRet = new SetReturnDataTypeCmd(s.getAddress(), (DataType)dvoid, SourceType.ANALYSIS);
                    cmdName.applyTo((DomainObject)program);
                    cmdRet.applyTo((DomainObject)program);
                    program.flushEvents();
                }
            }
            bmmanager.setBookmark(s.getAddress(), "Analysis", "eBPF-helpers", "eBPF-helper Identified");
        }
        return resultSet;
    }
}

