/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.TerminatedTransactionException;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.LockingTaskMonitor;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainObjectLockedException;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.List;

abstract class AbstractTransactionManager {
    protected static final int NUM_UNDOS = 50;
    private volatile LockingTaskMonitor lockingTaskMonitor;
    protected int lockCount = 0;
    protected String lockReason;
    boolean transactionTerminated;

    AbstractTransactionManager() {
    }

    abstract DomainObjectAdapterDB[] getDomainObjects();

    abstract void addTransactionListener(DomainObjectAdapterDB var1, TransactionListener var2);

    abstract void removeTransactionListener(DomainObjectAdapterDB var1, TransactionListener var2);

    abstract void clearTransactions();

    synchronized boolean isLocked() {
        return this.lockCount != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean lock(String reason) {
        this.checkLockingTask();
        AbstractTransactionManager abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            if (this.getCurrentTransactionInfo() != null && !this.transactionTerminated) {
                return false;
            }
            if (this.lockCount == 0) {
                for (DomainObjectAdapterDB domainObj : this.getDomainObjects()) {
                    if (!domainObj.isChanged()) continue;
                    domainObj.prepareToSave();
                }
            }
            this.lockReason = reason;
            ++this.lockCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized LockingTaskMonitor lockForSnapshot(DomainObjectAdapterDB domainObj, boolean hasProgress, String title) {
        if (SystemUtilities.isInHeadlessMode()) {
            Msg.warn((Object)this, (Object)"Snapshot not supported in headless mode");
            return null;
        }
        this.checkDomainObject(domainObj);
        if (this.lockCount != 0 || this.getCurrentTransactionInfo() != null || this.lockingTaskMonitor != null) {
            return null;
        }
        ++this.lockCount;
        try {
            if (this.lock("snapshot")) {
                LockingTaskMonitor lockingTaskMonitor = this.lockingTaskMonitor = new LockingTaskMonitor(domainObj, hasProgress, title);
                return lockingTaskMonitor;
            }
        }
        finally {
            --this.lockCount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void forceLock(boolean rollback, String reason) {
        AbstractTransactionManager abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            if (this.lockingTaskMonitor != null) {
                this.lockingTaskMonitor.cancel();
            }
        }
        this.checkLockingTask();
        abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            this.lockReason = reason;
            ++this.lockCount;
        }
        this.terminateTransaction(rollback, true);
    }

    abstract void terminateTransaction(boolean var1, boolean var2);

    final synchronized void unlock() {
        if (this.lockCount == 0) {
            throw new AssertException();
        }
        --this.lockCount;
    }

    final synchronized void unlock(LockingTaskMonitor handler) {
        if (handler == null) {
            throw new IllegalArgumentException("null handler");
        }
        if (this.lockCount != 1 || handler != this.lockingTaskMonitor) {
            throw new AssertException();
        }
        this.unlock();
        this.lockingTaskMonitor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkLockingTask() {
        AbstractTransactionManager abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            if (!this.isLocked() || this.lockingTaskMonitor == null) {
                return;
            }
        }
        this.lockingTaskMonitor.waitForTaskCompletion();
    }

    final void verifyNoLock() throws DomainObjectLockedException {
        if (this.lockCount != 0) {
            throw new DomainObjectLockedException(this.lockReason);
        }
    }

    void checkDomainObject(DomainObjectAdapterDB object) {
        boolean found = false;
        for (DomainObjectAdapterDB obj : this.getDomainObjects()) {
            if (obj != object) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("invalid domain object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startTransaction(DomainObjectAdapterDB object, String description, AbortedTransactionListener listener, boolean notify) throws TerminatedTransactionException {
        this.checkLockingTask();
        AbstractTransactionManager abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            this.checkDomainObject(object);
            if (this.getCurrentTransactionInfo() != null && this.transactionTerminated) {
                throw new TerminatedTransactionException();
            }
            return this.startTransaction(object, description, listener, false, notify);
        }
    }

    abstract int startTransaction(DomainObjectAdapterDB var1, String var2, AbortedTransactionListener var3, boolean var4, boolean var5);

    abstract TransactionInfo endTransaction(DomainObjectAdapterDB var1, int var2, boolean var3, boolean var4) throws IllegalStateException;

    abstract int getUndoStackDepth();

    abstract boolean canRedo();

    abstract boolean canUndo();

    abstract String getRedoName();

    abstract String getUndoName();

    abstract List<String> getAllUndoNames();

    abstract List<String> getAllRedoNames();

    abstract TransactionInfo getCurrentTransactionInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void redo() throws IOException {
        this.checkLockingTask();
        AbstractTransactionManager abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            if (this.getCurrentTransactionInfo() != null) {
                throw new IllegalStateException("Can not redo while transaction is open");
            }
            this.verifyNoLock();
            this.doRedo(true);
        }
    }

    abstract void doRedo(boolean var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void undo() throws IOException {
        this.checkLockingTask();
        AbstractTransactionManager abstractTransactionManager = this;
        synchronized (abstractTransactionManager) {
            if (this.getCurrentTransactionInfo() != null) {
                throw new IllegalStateException("Can not undo while transaction is open: " + this.getCurrentTransactionInfo().getDescription());
            }
            this.verifyNoLock();
            this.doUndo(true);
        }
    }

    abstract void doUndo(boolean var1) throws IOException;

    abstract void clearUndo(boolean var1);

    final synchronized boolean hasTerminatedTransaction() {
        return this.transactionTerminated;
    }

    final synchronized void close(DomainObjectAdapterDB object) {
        this.checkDomainObject(object);
        if (this.lockingTaskMonitor != null && this.lockingTaskMonitor.getDomainObject() == object) {
            this.lockingTaskMonitor.cancel();
        }
        this.verifyNoLock();
        this.doClose(object);
    }

    abstract void doClose(DomainObjectAdapterDB var1);
}

