/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PickToolDialog
extends DialogComponentProvider {
    private final FrontEndTool tool;
    private ToolTableModel model;
    private GTable table;
    private ToolTemplate selectedTemplate;
    private final Class<? extends DomainObject> domainClass;

    protected PickToolDialog(FrontEndTool tool, Class<? extends DomainObject> domainClass) {
        super("Pick Tool", true);
        this.tool = tool;
        this.domainClass = domainClass;
        this.setHelpLocation(new HelpLocation("Tool", "Set Tool Associations"));
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setPreferredSize(300, 400);
        this.setRememberLocation(false);
    }

    private JComponent createWorkPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.model = new ToolTableModel();
        this.table = new GTable((TableModel)((Object)this.model));
        this.table.setRowHeight(28);
        this.table.setColumnHeaderPopupEnabled(false);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(GhidraToolTemplate.class, (TableCellRenderer)((Object)new ToolTemplateRenderer()));
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.table.getSelectedRow();
            ToolTemplate template = (ToolTemplate)this.model.getRowObject(selectedRow);
            this.okButton.setEnabled(template != null);
        });
        this.loadList();
        mainPanel.add((Component)new JScrollPane((Component)this.table), "Center");
        return mainPanel;
    }

    private void loadList() {
        Project project = this.tool.getProject();
        ToolServices toolServices = project.getToolServices();
        Set<ToolTemplate> compatibleTools = toolServices.getCompatibleTools(this.domainClass);
        this.model.setData(new ArrayList<ToolTemplate>(compatibleTools));
    }

    void showDialog() {
        this.clearStatusText();
        this.tool.showDialog(this);
    }

    protected void okCallback() {
        int selectedRow = this.table.getSelectedRow();
        this.selectedTemplate = (ToolTemplate)this.model.getRowObject(selectedRow);
        this.close();
    }

    ToolTemplate getSelectedToolTemplate() {
        return this.selectedTemplate;
    }

    private class ToolTableModel
    extends AbstractSortedTableModel<ToolTemplate> {
        private List<ToolTemplate> data;

        ToolTableModel() {
            super(0);
            this.data = Collections.emptyList();
        }

        void setData(List<ToolTemplate> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        public String getName() {
            return "Tool Picker";
        }

        public Object getColumnValueForRow(ToolTemplate t, int column) {
            return t;
        }

        public String getColumnName(int column) {
            return "Tool";
        }

        public Class<?> getColumnClass(int column) {
            return GhidraToolTemplate.class;
        }

        public List<ToolTemplate> getModelData() {
            return this.data;
        }

        public boolean isSortable(int columnIndex) {
            return columnIndex == 0;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return this.data.size();
        }

        protected Comparator<ToolTemplate> createSortComparator(int column) {
            return new ToolTemplateComparator();
        }
    }

    private class ToolTemplateRenderer
    extends GTableCellRenderer {
        private ToolTemplateRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            ToolTemplate template = (ToolTemplate)value;
            if (template == null) {
                return renderer;
            }
            renderer.setIcon(template.getIcon());
            renderer.setText(template.getName());
            return renderer;
        }
    }

    private class ToolTemplateComparator
    implements Comparator<ToolTemplate> {
        private ToolTemplateComparator() {
        }

        @Override
        public int compare(ToolTemplate o1, ToolTemplate o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

