/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import db.Transaction;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.Undoable;
import ghidra.framework.store.LockException;
import utility.function.ExceptionalCallback;
import utility.function.ExceptionalSupplier;

public interface UndoableDomainObject
extends DomainObject,
Undoable {
    public Transaction openTransaction(String var1) throws IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Exception> void withTransaction(String description, ExceptionalCallback<E> callback) throws E {
        int id = this.startTransaction(description);
        try {
            callback.call();
        }
        finally {
            this.endTransaction(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Exception, T> T withTransaction(String description, ExceptionalSupplier<T, E> supplier) throws E {
        Object t = null;
        boolean success = false;
        int id = this.startTransaction(description);
        try {
            t = supplier.get();
            success = true;
        }
        finally {
            this.endTransaction(id, success);
        }
        return (T)t;
    }

    public int startTransaction(String var1);

    public int startTransaction(String var1, AbortedTransactionListener var2);

    public void endTransaction(int var1, boolean var2);

    public TransactionInfo getCurrentTransactionInfo();

    public boolean hasTerminatedTransaction();

    public DomainObject[] getSynchronizedDomainObjects();

    public void addSynchronizedDomainObject(DomainObject var1) throws LockException;

    public void releaseSynchronizedDomainObject() throws LockException;
}

