/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.DialogComponentProvider;
import docking.util.image.ToolIconURL;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.IconMap;
import ghidra.framework.plugintool.dialog.ToolIconUrlRenderer;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.HelpLocation;
import ghidra.util.NamingUtilities;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import resources.ResourceManager;

public class SaveToolConfigDialog
extends DialogComponentProvider
implements ListSelectionListener {
    static final String LAST_ICON_DIRECTORY = "LastIconDirectory";
    private ToolServices toolServices;
    private PluginTool tool;
    private ToolChest toolChest;
    private String defaultName;
    private ToolIconURL iconURL;
    private boolean selectionChanging;
    private JTextField nameField;
    private JList<ToolIconURL> iconList;
    private DefaultListModel<ToolIconURL> iconListModel;
    private JTextField iconField;
    private JButton browseButton;
    private JButton saveButton;
    private boolean didCancel;

    public SaveToolConfigDialog(PluginTool tool, ToolServices toolServices) {
        super("Save Tool to Tool Chest", true);
        this.tool = tool;
        this.toolServices = toolServices;
        this.addWorkPanel(this.buildMainPanel());
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(ev -> this.save());
        this.addButton(this.saveButton);
        this.addCancelButton();
        this.toolChest = toolServices.getToolChest();
        this.addListeners();
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Save Tool"));
    }

    protected JPanel buildMainPanel() {
        JPanel iconPanel = this.createIconPanel();
        JPanel iconFieldPanel = this.createIconFieldPanel();
        this.addIconPanelListeners();
        JPanel toolFieldPanel = this.createToolFieldPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolFieldPanel, "North");
        panel.add((Component)iconPanel, "Center");
        panel.add((Component)iconFieldPanel, "South");
        panel.setPreferredSize(new Dimension(400, 300));
        return panel;
    }

    public void show(String name, String newDefaultName) {
        ToolTemplate[] template;
        this.defaultName = newDefaultName;
        this.didCancel = false;
        this.iconListModel.removeAllElements();
        this.loadIcons();
        for (ToolTemplate element : template = this.toolChest.getToolTemplates()) {
            ToolIconURL iconUrl = ((GhidraToolTemplate)element).getIconURL();
            this.updateMap(iconUrl);
        }
        this.nameField.setText(newDefaultName);
        this.setFocusComponent(this.nameField);
        this.nameField.selectAll();
        ToolIconURL iconUrl = this.tool.getIconURL();
        ImageIcon icon = iconUrl.getIcon();
        String iconName = null;
        if (icon != null) {
            String location = iconUrl.getLocation();
            File file = new File(location);
            iconName = file.exists() ? location : ResourceManager.getIconName((Icon)icon);
            this.iconField.setText(iconName);
            this.updateMap(iconUrl);
        }
        this.loadIcons();
        if (iconName != null) {
            this.iconList.setSelectedValue(iconUrl, true);
        }
        this.tool.showDialog(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList theList = (JList)e.getSource();
        if (theList.isSelectionEmpty()) {
            this.saveButton.setEnabled(false);
        } else {
            int index = theList.getSelectedIndex();
            ToolIconURL url = this.iconListModel.get(index);
            this.selectionChanging = true;
            this.iconField.setText(url.getLocation());
            this.selectionChanging = false;
            this.setPicture(url);
        }
    }

    private void addListeners() {
        this.nameField.addActionListener(e -> this.save());
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SaveToolConfigDialog.this.clearStatusText();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save() {
        String newName = this.nameField.getText().trim();
        if (newName.length() == 0) {
            this.setStatusText("Please enter or select a name.");
            return;
        }
        if (newName.indexOf(" ") >= 0) {
            this.setStatusText("Name cannot have spaces.");
            this.nameField.requestFocus();
            return;
        }
        if (!NamingUtilities.isValidName((String)newName)) {
            this.setStatusText("Invalid character in name: " + NamingUtilities.findInvalidChar((String)newName));
            this.nameField.requestFocus();
            return;
        }
        if (newName.equals(this.defaultName)) {
            this.saveToolConfig();
        } else if (this.isOverwriteExistingTool(newName)) {
            if (OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Overwrite Tool?", (String)("Overwrite existing tool, " + newName + "?"), (String)"Overwrite", (int)3) != 1) return;
            this.tool.setToolName(newName);
            this.saveToolConfig();
        } else {
            this.tool.setToolName(newName);
            this.saveToolConfig();
        }
        this.close();
    }

    private boolean isOverwriteExistingTool(String newName) {
        ToolTemplate[] templates;
        for (ToolTemplate template : templates = this.toolChest.getToolTemplates()) {
            if (!template.getName().equals(newName)) continue;
            return true;
        }
        return false;
    }

    protected void cancelCallback() {
        this.didCancel = true;
        this.close();
    }

    public boolean didCancel() {
        return this.didCancel;
    }

    private JPanel createToolFieldPanel() {
        JPanel namePanel = new JPanel((LayoutManager)new PairLayout(5, 5, 150));
        Border border = BorderFactory.createEmptyBorder(5, 3, 3, 3);
        namePanel.setBorder(border);
        this.nameField = new JTextField(11);
        this.nameField.setName("ToolName");
        namePanel.add((Component)new GLabel("Tool Name:", 4));
        namePanel.add(this.nameField);
        return namePanel;
    }

    private JPanel createIconPanel() {
        this.iconListModel = new DefaultListModel();
        this.loadIcons();
        this.iconList = new JList<ToolIconURL>(this.iconListModel);
        this.iconList.setLayoutOrientation(2);
        this.iconList.setName("IconList");
        this.iconList.setCellRenderer((ListCellRenderer<ToolIconURL>)((Object)new ToolIconUrlRenderer()));
        this.iconList.setSelectionMode(0);
        this.iconList.setSelectedIndex(0);
        this.iconList.setVisibleRowCount(2);
        this.iconList.addListSelectionListener(this);
        JScrollPane iconListScrollPane = new JScrollPane(this.iconList);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Choose Icon"));
        panel.add((Component)iconListScrollPane, "Center");
        return panel;
    }

    private JPanel createIconFieldPanel() {
        this.iconField = new JTextField(12);
        this.iconField.setName("IconName");
        this.browseButton = new BrowseButton();
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)new GLabel("Icon Name:"), "West");
        panel.add((Component)this.iconField, "Center");
        panel.add((Component)this.browseButton, "East");
        return panel;
    }

    private void addIconPanelListeners() {
        this.iconField.addActionListener(e -> {
            String filename = this.iconField.getText();
            if (filename.length() == 0) {
                this.setStatusText("Please enter a filename for the icon.");
                return;
            }
            this.setPicture(new ToolIconURL(filename));
        });
        this.iconField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SaveToolConfigDialog.this.clearStatusText();
            }
        });
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SaveToolConfigDialog.this.lookupIconName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SaveToolConfigDialog.this.lookupIconName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SaveToolConfigDialog.this.lookupIconName();
            }
        };
        this.iconField.getDocument().addDocumentListener(dl);
        this.browseButton.addActionListener(e -> this.browseForIcons());
    }

    private void lookupIconName() {
        if (this.selectionChanging) {
            return;
        }
        String str = this.iconField.getText();
        for (int i = 0; i < this.iconListModel.getSize(); ++i) {
            ToolIconURL url = this.iconListModel.get(i);
            if (!url.getLocation().equals(str)) continue;
            Rectangle r = this.iconList.getCellBounds(i, i);
            this.iconList.scrollRectToVisible(r);
            break;
        }
    }

    private void browseForIcons() {
        File dir;
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setTitle("Choose Icon");
        chooser.setApproveButtonToolTipText("Choose Icon");
        chooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"gif", "jpg", "bmp", "png"}, "Image Files"));
        String iconDir = Preferences.getProperty((String)LAST_ICON_DIRECTORY);
        if (iconDir != null && (dir = new File(iconDir)).isDirectory()) {
            chooser.setCurrentDirectory(dir);
        }
        File file = chooser.getSelectedFile();
        chooser.dispose();
        if (file == null) {
            return;
        }
        String filename = file.getAbsolutePath();
        this.iconField.setText(filename);
        ToolIconURL url = new ToolIconURL(filename);
        this.iconListModel.addElement(url);
        this.iconList.setSelectedValue(url, true);
        this.setPicture(url);
        Preferences.setProperty((String)LAST_ICON_DIRECTORY, (String)file.getParent());
    }

    private void setPicture(ToolIconURL url) {
        boolean isAnimated = url.isAnimated();
        if (isAnimated) {
            this.setStatusText("Animated Icon not permitted.");
            this.saveButton.setEnabled(false);
        } else {
            this.clearStatusText();
            this.saveButton.setEnabled(true);
        }
        this.iconURL = url;
    }

    private void saveToolConfig() {
        String iconName;
        if (this.iconURL == null && (iconName = this.iconField.getText()).length() > 0) {
            this.iconURL = new ToolIconURL(iconName);
        }
        if (this.iconURL != null) {
            this.tool.setIconURL(this.iconURL);
            IconMap.put(this.iconURL.getLocation(), this.iconURL);
        }
        this.toolServices.saveTool(this.tool);
    }

    private void loadIcons() {
        this.iconListModel.removeAllElements();
        List<ToolIconURL> urls = IconMap.getIcons();
        for (ToolIconURL url : urls) {
            this.iconListModel.addElement(url);
        }
    }

    private void updateMap(ToolIconURL url) {
        if (!this.iconListModel.contains(url)) {
            IconMap.put(url.getLocation(), url);
            this.loadIcons();
        }
    }
}

