/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GHtmlLabel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectChangedToolDialog
extends DialogComponentProvider {
    private final List<PluginTool> toolList;
    private boolean wasCancelled;
    private PluginTool selectedTool;

    public SelectChangedToolDialog(List<PluginTool> toolList) {
        super("Save Tool Changes?", true, false, true, false);
        this.toolList = toolList;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        Dimension preferredSize = this.getPreferredSize();
        this.setPreferredSize(preferredSize.width, Math.min(300, preferredSize.height));
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    private JPanel buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String toolName = this.toolList.get(0).getToolName();
        GHtmlLabel descriptionLabel = new GHtmlLabel(HTMLUtilities.toHTML((String)("There are multiple changed instances of " + HTMLUtilities.escapeHTML((String)toolName) + " running.<p>Which one would like to save to your tool chest?")));
        descriptionLabel.setIconTextGap(15);
        descriptionLabel.setIcon(OptionDialog.getIconForMessageType((int)2));
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)descriptionLabel, "North");
        JScrollPane scrollPane = new JScrollPane(this.buildRadioButtonPanel());
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(scrollPane);
        return panel;
    }

    private JPanel buildRadioButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        ButtonGroup buttonGroup = new ButtonGroup();
        GRadioButton noneButton = new GRadioButton("None");
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectChangedToolDialog.this.selectedTool = null;
            }
        };
        noneButton.addItemListener(listener);
        buttonGroup.add((AbstractButton)noneButton);
        panel.add((Component)noneButton);
        for (final PluginTool tool : this.toolList) {
            GRadioButton radioButton = new GRadioButton(tool.getName());
            radioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SelectChangedToolDialog.this.selectedTool = tool;
                }
            });
            buttonGroup.add((AbstractButton)radioButton);
            panel.add((Component)radioButton);
        }
        buttonGroup.setSelected(noneButton.getModel(), true);
        return panel;
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.wasCancelled = true;
    }

    protected void okCallback() {
        this.close();
    }

    boolean wasCancelled() {
        return this.wasCancelled;
    }

    PluginTool getSelectedTool() {
        return this.selectedTool;
    }
}

