/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.MonitorContendedEnterEvent;
import com.sun.jdi.event.MonitorContendedEnteredEvent;
import com.sun.jdi.event.MonitorWaitEvent;
import com.sun.jdi.event.MonitorWaitedEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import ghidra.async.AsyncReference;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListener;
import ghidra.dbg.jdi.manager.JdiStateListener;
import ghidra.dbg.jdi.manager.JdiThreadInfo;
import ghidra.dbg.jdi.manager.impl.DebugStatus;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import ghidra.util.datastruct.ListenerSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class JdiEventHandler
implements Runnable {
    volatile boolean connected = true;
    boolean completed = false;
    String shutdownMessageKey;
    private VirtualMachine vm;
    private Thread thread;
    private JdiEventHandler global;
    protected final AsyncReference<Integer, JdiCause> state = new AsyncReference((Object)5);
    public final ListenerSet<JdiEventsListener> listenersEvent = new ListenerSet(JdiEventsListener.class, true);
    protected final ExecutorService eventThread = Executors.newSingleThreadExecutor();
    private boolean vmDied = false;

    public JdiEventHandler() {
    }

    public JdiEventHandler(VirtualMachine vm, JdiEventHandler global) {
        this.vm = vm;
        this.global = global;
        this.state.filter(this::stateFilter);
    }

    public void start() {
        this.thread = new Thread((Runnable)this, "event-handler");
        this.thread.start();
    }

    synchronized void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public CompletableFuture<Void> event(Runnable r, String text) {
        return CompletableFuture.runAsync(r, this.eventThread).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Error in event callback:", (Throwable)ex);
            return (Void)ExceptionUtils.rethrow((Throwable)ex);
        });
    }

    public void addStateListener(JdiStateListener listener) {
        this.state.addChangeListener((TriConsumer)listener);
    }

    public void removeStateListener(JdiStateListener listener) {
        this.state.removeChangeListener((TriConsumer)listener);
    }

    public void addEventsListener(JdiEventsListener listener) {
        this.listenersEvent.add((Object)listener);
    }

    public void removeEventsListener(JdiEventsListener listener) {
        this.listenersEvent.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                DebugStatus status = DebugStatus.BREAK;
                this.state.set((Object)4, (Object)JdiCause.Causes.UNCLAIMED);
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    Event nextEvent = it.nextEvent();
                    this.global.processEvent(nextEvent);
                    status = DebugStatus.update(this.processEvent(nextEvent));
                }
                if (status.equals((Object)DebugStatus.GO)) {
                    this.state.set((Object)1, (Object)JdiCause.Causes.UNCLAIMED);
                    eventSet.resume();
                    continue;
                }
                if (eventSet.suspendPolicy() != 2) continue;
                this.setCurrentThread(eventSet);
                this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).processStop(eventSet, JdiCause.Causes.UNCLAIMED), "processStopped");
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.handleDisconnectedException();
                break;
            }
        }
        JdiEventHandler jdiEventHandler = this;
        synchronized (jdiEventHandler) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private DebugStatus processEvent(Event event) {
        System.err.println(event + ":" + this.vm);
        if (event instanceof ExceptionEvent) {
            return this.processException((ExceptionEvent)event);
        }
        if (event instanceof BreakpointEvent) {
            return this.processBreakpoint((BreakpointEvent)event);
        }
        if (event instanceof WatchpointEvent) {
            return this.processWatchpoint((WatchpointEvent)event);
        }
        if (event instanceof AccessWatchpointEvent) {
            return this.processAccessWatchpoint((AccessWatchpointEvent)event);
        }
        if (event instanceof ModificationWatchpointEvent) {
            return this.processWatchpointModification((ModificationWatchpointEvent)event);
        }
        if (event instanceof StepEvent) {
            return this.processStep((StepEvent)event);
        }
        if (event instanceof MethodEntryEvent) {
            return this.processMethodEntry((MethodEntryEvent)event);
        }
        if (event instanceof MethodExitEvent) {
            return this.processMethodExit((MethodExitEvent)event);
        }
        if (event instanceof MonitorContendedEnteredEvent) {
            return this.processMCEntered((MonitorContendedEnteredEvent)event);
        }
        if (event instanceof MonitorContendedEnterEvent) {
            return this.processMCEnter((MonitorContendedEnterEvent)event);
        }
        if (event instanceof MonitorWaitedEvent) {
            return this.processMonitorWaited((MonitorWaitedEvent)event);
        }
        if (event instanceof MonitorWaitEvent) {
            return this.processMonitorWait((MonitorWaitEvent)event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.processClassPrepare((ClassPrepareEvent)event);
        }
        if (event instanceof ClassUnloadEvent) {
            return this.processClassUnload((ClassUnloadEvent)event);
        }
        if (event instanceof ThreadStartEvent) {
            return this.processThreadStart((ThreadStartEvent)event);
        }
        if (event instanceof ThreadDeathEvent) {
            return this.processThreadDeath((ThreadDeathEvent)event);
        }
        if (event instanceof VMStartEvent) {
            return this.processVMStart((VMStartEvent)event);
        }
        if (event instanceof VMDisconnectEvent) {
            return this.processVMDisconnect((VMDisconnectEvent)event);
        }
        if (event instanceof VMDeathEvent) {
            return this.processVMDeath((VMDeathEvent)event);
        }
        System.err.println("Unknown event: " + event);
        return null;
    }

    private DebugStatus handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.vmDied = true;
            return this.processVMDeath((VMDeathEvent)event);
        }
        if (event instanceof VMDisconnectEvent) {
            this.connected = false;
            if (!this.vmDied) {
                this.processVMDisconnect((VMDisconnectEvent)event);
            }
            this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).processShutdown(event, JdiCause.Causes.UNCLAIMED), "processStopped");
            return null;
        }
        throw new InternalError();
    }

    synchronized void handleDisconnectedException() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    this.handleExitEvent((Event)iter.next());
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InternalError internalError) {
            }
        }
    }

    private ThreadReference eventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private void setCurrentThread(EventSet set) {
        ThreadReference thread;
        if (set.size() > 0) {
            Event event = (Event)set.iterator().next();
            thread = this.eventThread(event);
        } else {
            thread = null;
        }
        this.setCurrentThread(thread);
    }

    private void setCurrentThread(ThreadReference thread) {
        JdiThreadInfo.invalidateAll();
        JdiThreadInfo.setCurrentThread(thread);
    }

    protected DebugStatus processBreakpoint(BreakpointEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).breakpointHit(evt, JdiCause.Causes.UNCLAIMED), "breakpointHit");
        return DebugStatus.BREAK;
    }

    protected DebugStatus processException(ExceptionEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).exceptionHit(evt, JdiCause.Causes.UNCLAIMED), "exceptionHit");
        return DebugStatus.BREAK;
    }

    protected DebugStatus processMethodEntry(MethodEntryEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).methodEntry(evt, JdiCause.Causes.UNCLAIMED), "methodEntry");
        return DebugStatus.GO;
    }

    protected DebugStatus processMethodExit(MethodExitEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).methodExit(evt, JdiCause.Causes.UNCLAIMED), "methodExit");
        return DebugStatus.GO;
    }

    protected DebugStatus processClassPrepare(ClassPrepareEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).classPrepare(evt, JdiCause.Causes.UNCLAIMED), "classPrepare");
        return DebugStatus.GO;
    }

    protected DebugStatus processClassUnload(ClassUnloadEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).classUnload(evt, JdiCause.Causes.UNCLAIMED), "classUnload");
        return DebugStatus.GO;
    }

    protected DebugStatus processMCEntered(MonitorContendedEnteredEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).monitorContendedEntered(evt, JdiCause.Causes.UNCLAIMED), "monitorContendedEntered");
        return DebugStatus.GO;
    }

    protected DebugStatus processMCEnter(MonitorContendedEnterEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).monitorContendedEnter(evt, JdiCause.Causes.UNCLAIMED), "monitorContendedEnter");
        return DebugStatus.GO;
    }

    protected DebugStatus processMonitorWaited(MonitorWaitedEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).monitorWaited(evt, JdiCause.Causes.UNCLAIMED), "monitorWaited");
        return DebugStatus.GO;
    }

    protected DebugStatus processMonitorWait(MonitorWaitEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).monitorWait(evt, JdiCause.Causes.UNCLAIMED), "monitorWait");
        return DebugStatus.GO;
    }

    protected DebugStatus processStep(StepEvent evt) {
        evt.request().disable();
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).stepComplete(evt, JdiCause.Causes.UNCLAIMED), "step");
        return DebugStatus.STEP_INTO;
    }

    protected DebugStatus processWatchpoint(WatchpointEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).watchpointHit(evt, JdiCause.Causes.UNCLAIMED), "watchpointHit");
        return DebugStatus.BREAK;
    }

    protected DebugStatus processAccessWatchpoint(AccessWatchpointEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).accessWatchpointHit(evt, JdiCause.Causes.UNCLAIMED), "accessWatchpointHit");
        return DebugStatus.BREAK;
    }

    protected DebugStatus processWatchpointModification(ModificationWatchpointEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).watchpointModified(evt, JdiCause.Causes.UNCLAIMED), "watchpointModified");
        return DebugStatus.GO;
    }

    protected DebugStatus processThreadDeath(ThreadDeathEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).threadExited(evt, JdiCause.Causes.UNCLAIMED), "threadExited");
        JdiThreadInfo.removeThread(evt.thread());
        return DebugStatus.GO;
    }

    protected DebugStatus processThreadStart(ThreadStartEvent evt) {
        JdiThreadInfo.addThread(evt.thread());
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).threadStarted(evt, JdiCause.Causes.UNCLAIMED), "threadStarted");
        return DebugStatus.GO;
    }

    protected DebugStatus processVMDeath(VMDeathEvent evt) {
        this.shutdownMessageKey = "The application exited";
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).vmDied(evt, JdiCause.Causes.UNCLAIMED), "vmDied");
        return DebugStatus.BREAK;
    }

    protected DebugStatus processVMDisconnect(VMDisconnectEvent evt) {
        this.shutdownMessageKey = "The application has been disconnected";
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).vmDisconnected(evt, JdiCause.Causes.UNCLAIMED), "vmDisconnected");
        return DebugStatus.BREAK;
    }

    protected DebugStatus processVMStart(VMStartEvent evt) {
        this.event(() -> ((JdiEventsListener)this.listenersEvent.invoke()).vmStarted(evt, JdiCause.Causes.UNCLAIMED), "vmStarted");
        return DebugStatus.BREAK;
    }

    public Integer getState() {
        return (Integer)this.state.get();
    }

    public void setState(Integer val, JdiCause cause) {
        this.state.set((Object)val, (Object)cause);
    }

    private Integer stateFilter(Integer cur, Integer set, JdiCause cause) {
        if (set == null) {
            return cur;
        }
        return set;
    }
}

