/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ThreadGroupReference;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetThreadContainer;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ThreadGroupContainer", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=JdiModelTargetThreadGroupContainer.class)}, canonicalContainer=true)
public class JdiModelTargetThreadGroupContainer
extends JdiModelTargetObjectImpl
implements JdiEventsListenerAdapter {
    protected final ThreadGroupReference baseGroup;
    protected final Map<String, JdiModelTargetThreadGroupContainer> threadGroupsById = new WeakValueHashMap();

    protected static String keyGroup(ThreadGroupReference group) {
        return PathUtils.makeKey((String)group.name());
    }

    public JdiModelTargetThreadGroupContainer(JdiModelTargetVM parent) {
        super(parent, "Thread Groups");
        this.baseGroup = null;
    }

    public JdiModelTargetThreadGroupContainer(JdiModelTargetObject parent, ThreadGroupReference group, boolean isElement) {
        super(parent, isElement ? JdiModelTargetThreadGroupContainer.keyGroup(group) : group.name());
        this.baseGroup = group;
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        List<ThreadGroupReference> groups;
        if (this.parent instanceof JdiModelTargetVM) {
            JdiModelTargetVM vm = (JdiModelTargetVM)this.parent;
            groups = vm.vm.topLevelThreadGroups();
        } else {
            groups = this.baseGroup.threadGroups();
            if (!this.baseGroup.threads().isEmpty()) {
                JdiModelTargetThreadContainer c = new JdiModelTargetThreadContainer(this, "Threads", this.baseGroup.threads());
                this.changeAttributes(List.of(), List.of(c), Map.of(), "Refreshed");
            }
        }
        this.updateUsingThreadGroups(groups);
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUsingThreadGroups(List<ThreadGroupReference> refs) {
        List threadGroups;
        JdiModelTargetThreadGroupContainer jdiModelTargetThreadGroupContainer = this;
        synchronized (jdiModelTargetThreadGroupContainer) {
            threadGroups = refs.stream().map(this::getTargetThreadGroup).collect(Collectors.toList());
        }
        this.setElements(threadGroups, Map.of(), "Refreshed");
    }

    public synchronized JdiModelTargetThreadGroupContainer getTargetThreadGroup(ThreadGroupReference group) {
        return this.threadGroupsById.computeIfAbsent(group.name(), i -> new JdiModelTargetThreadGroupContainer(this, group, true));
    }
}

