/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.control;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgeng.impl.dbgeng.DbgEngUtil;
import agent.dbgeng.impl.dbgeng.breakpoint.DebugBreakpointInternal;
import agent.dbgeng.impl.dbgeng.control.DebugControlImpl3;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.breakpoint.IDebugBreakpoint;
import agent.dbgeng.jna.dbgeng.breakpoint.WrapIDebugBreakpoint;
import agent.dbgeng.jna.dbgeng.control.IDebugControl4;
import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.comm.util.BitmaskSet;

public class DebugControlImpl4
extends DebugControlImpl3 {
    private final IDebugControl4 jnaControl;

    public DebugControlImpl4(IDebugControl4 jnaControl) {
        super(jnaControl);
        this.jnaControl = jnaControl;
    }

    @Override
    public void print(BitmaskSet<DebugControl.DebugOutputLevel> levels, String message) {
        WinDef.ULONG mask = new WinDef.ULONG(levels.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.OutputWide(mask, new WString("%s"), new WString(message)));
    }

    @Override
    public void println(BitmaskSet<DebugControl.DebugOutputLevel> levels, String message) {
        WinDef.ULONG mask = new WinDef.ULONG(levels.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.OutputWide(mask, new WString("%s"), new WString(message + "\r\n")));
    }

    @Override
    public void prompt(BitmaskSet<DebugControl.DebugOutputControl> ctl, String message) {
        WinDef.ULONG ctlMask = new WinDef.ULONG(ctl.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.OutputPromptWide(ctlMask, new WString("%s"), new WString(message)));
    }

    @Override
    public String getPromptText() {
        WinDef.ULONGByReference pulTextSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetPromptTextWide(null, new WinDef.ULONG(0L), pulTextSize));
        char[] buffer = new char[pulTextSize.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.GetPromptTextWide(buffer, pulTextSize.getValue(), null));
        return Native.toString((char[])buffer);
    }

    @Override
    protected DbgEngNative.DEBUG_VALUE doEval(DebugValue.DebugValueType type, String expression) {
        DbgEngNative.DEBUG_VALUE.ByReference value = new DbgEngNative.DEBUG_VALUE.ByReference();
        WinDef.ULONGByReference pulRemainder = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.EvaluateWide(new WString(expression), new WinDef.ULONG((long)type.ordinal()), value, pulRemainder));
        int remainder = pulRemainder.getValue().intValue();
        if (remainder != expression.length()) {
            throw new RuntimeException("Failed to parse: " + expression.substring(remainder));
        }
        return value;
    }

    @Override
    public void execute(BitmaskSet<DebugControl.DebugOutputControl> ctl, String cmd, BitmaskSet<DebugControl.DebugExecute> flags) {
        WinDef.ULONG flagMask;
        WinDef.ULONG ctlMask = new WinDef.ULONG(ctl.getBitmask());
        WinNT.HRESULT hr = this.jnaControl.ExecuteWide(ctlMask, new WString(cmd), flagMask = new WinDef.ULONG(flags.getBitmask()));
        if (hr.equals((Object)COMUtilsExtra.E_INTERNALEXCEPTION)) {
            return;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
    }

    @Override
    public void returnInput(String input) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.ReturnInputWide(new WString(input)));
    }

    public DebugBreakpoint doAddBreakpoint2(DebugBreakpoint.BreakType type, WinDef.ULONG ulDesiredId) {
        WinDef.ULONG ulType = new WinDef.ULONG((long)type.ordinal());
        PointerByReference ppBp = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaControl.AddBreakpoint2(ulType, ulDesiredId, ppBp));
        WrapIDebugBreakpoint Bp = new WrapIDebugBreakpoint(ppBp.getValue());
        DebugBreakpointInternal bpt = DebugBreakpointInternal.tryPreferredInterfaces(this, (arg_0, arg_1) -> ((IDebugBreakpoint)Bp).QueryInterface(arg_0, arg_1));
        return bpt;
    }

    @Override
    public DebugBreakpoint addBreakpoint2(DebugBreakpoint.BreakType type, int desiredId) {
        return this.doAddBreakpoint2(type, new WinDef.ULONG((long)desiredId));
    }

    @Override
    public DebugBreakpoint addBreakpoint2(DebugBreakpoint.BreakType type) {
        return this.doAddBreakpoint2(type, DbgEngUtil.DEBUG_ANY_ID);
    }
}

