/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.comm.util.BitmaskSet;

public class DbgLaunchProcessCommand
extends AbstractDbgCommand<DbgThread> {
    private DbgProcessCreatedEvent created = null;
    private boolean completed = false;
    private String args;
    private String initialDirectory;
    private String environment;
    private BitmaskSet<DebugClient.DebugCreateFlags> createFlags;
    private BitmaskSet<DebugClient.DebugEngCreateFlags> engCreateFlags;
    private BitmaskSet<DebugClient.DebugVerifierFlags> verifierFlags;

    public DbgLaunchProcessCommand(DbgManagerImpl manager, String args, String initialDirectory, String environment, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, BitmaskSet<DebugClient.DebugEngCreateFlags> engCreateFlags, BitmaskSet<DebugClient.DebugVerifierFlags> verifierFlags) {
        super(manager);
        this.args = args;
        this.initialDirectory = initialDirectory;
        this.environment = environment;
        this.createFlags = createFlags;
        this.engCreateFlags = engCreateFlags;
        this.verifierFlags = verifierFlags;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof DbgProcessCreatedEvent) {
            this.created = (DbgProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public DbgThread complete(DbgPendingCommand<?> pending) {
        DebugProcessInfo info = (DebugProcessInfo)this.created.getInfo();
        DebugThreadInfo tinfo = info.initialThreadInfo;
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId tid = so.getThreadIdByHandle(tinfo.handle);
        return this.manager.getThread(tid);
    }

    @Override
    public void invoke() {
        DebugClient dbgeng = this.manager.getClient();
        this.initialDirectory = this.fixPath(this.initialDirectory);
        this.environment = this.fixPath(this.environment);
        if (this.environment != null) {
            this.environment = this.environment.replace("\\0", "\u0000");
        }
        dbgeng.createProcess(dbgeng.getLocalServer(), this.args, this.initialDirectory, this.environment, this.createFlags, this.engCreateFlags, this.verifierFlags);
        this.manager.waitForEventEx();
    }

    private String fixPath(String input) {
        if (input == null || input.equals("")) {
            return null;
        }
        String output = input;
        if (input.startsWith("/")) {
            output = output.substring(1);
        }
        output = output.replace("/", "\\");
        return output;
    }
}

