/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgeng.manager.impl.DbgRegisterSet;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetRegister;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.util.ConversionUtils;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public interface DbgModelTargetRegisterBank
extends DbgModelTargetObject,
TargetRegisterBank {
    public DbgModelTargetRegister getTargetRegister(DbgRegister var1);

    default public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        return this.getModel().gateFuture(this.doReadRegistersNamed(names));
    }

    default public CompletableFuture<? extends Map<String, byte[]>> doReadRegistersNamed(Collection<String> names) {
        DbgManagerImpl manager = this.getManager();
        if (manager.isWaiting()) {
            Msg.warn((Object)this, (Object)"Cannot process command readRegistersNamed while engine is waiting for events");
        }
        AtomicReference read = new AtomicReference();
        return ((CompletableFuture)this.getManager().getRegisterMap(this.getPath()).thenCompose(valueMap -> {
            Map regs = this.getCachedAttributes();
            HashMap<DbgRegister, DbgModelTargetRegister> map = new HashMap<DbgRegister, DbgModelTargetRegister>();
            for (String regname : names) {
                Object x = regs.get(regname);
                if (!(x instanceof DbgModelTargetRegister) || !valueMap.containsKey(regname)) continue;
                DbgModelTargetRegister reg = (DbgModelTargetRegister)x;
                DbgRegister register = (DbgRegister)valueMap.get(regname);
                if (register == null) continue;
                map.put(register, reg);
            }
            read.set(map);
            return this.getParentThread().getThread().readRegisters(map.keySet());
        })).thenApply(vals -> {
            LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
            for (DbgRegister dbgReg : vals.keySet()) {
                DbgModelTargetRegister reg = (DbgModelTargetRegister)((Map)read.get()).get(dbgReg);
                String oldval = (String)reg.getCachedAttributes().get("_value");
                BigInteger value = (BigInteger)vals.get(dbgReg);
                byte[] bytes = ConversionUtils.bigIntegerToBytes((int)dbgReg.getSize(), (BigInteger)value);
                result.put(dbgReg.getName(), bytes);
                reg.changeAttributes(List.of(), Map.of("_value", value.toString(16)), "Refreshed");
                if (value.longValue() == 0L) continue;
                String valstr = Long.toUnsignedString(value.longValue(), 16);
                String newval = reg.getName() + " : " + valstr;
                reg.changeAttributes(List.of(), Map.of("_display", newval), "Refreshed");
                reg.setModified(valstr.equals(oldval));
            }
            this.broadcast().registersUpdated(this.getProxy(), result);
            return result;
        });
    }

    default public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        return this.getModel().gateFuture(this.doWriteRegistersNamed(values));
    }

    default public CompletableFuture<Void> doWriteRegistersNamed(Map<String, byte[]> values) {
        DbgManagerImpl manager = this.getManager();
        DbgThread thread = this.getParentThread().getThread();
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.requestNativeElements().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).nextIgnore(arg_0, arg_1))).then(seq -> thread.listRegisters().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), TypeSpec.cls(DbgRegisterSet.class)).then((regset, seq) -> {
            Map regs = this.getCachedAttributes();
            LinkedHashMap<DbgRegister, BigInteger> toWrite = new LinkedHashMap<DbgRegister, BigInteger>();
            for (Map.Entry ent : values.entrySet()) {
                String regname = (String)ent.getKey();
                DbgModelTargetRegister reg = (DbgModelTargetRegister)regs.get(regname);
                if (reg == null) {
                    throw new DebuggerRegisterAccessException("No such register: " + regname);
                }
                BigInteger val = new BigInteger(1, (byte[])ent.getValue());
                DbgRegister dbgreg = regset.get(regname);
                toWrite.put(dbgreg, val);
            }
            this.getParentThread().getThread().writeRegisters(toWrite).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1));
        }).then(seq -> {
            ((DbgEventsListener)manager.getEventListeners().invoke()).threadStateChanged(thread, thread.getState(), DbgCause.Causes.UNCLAIMED, DbgReason.Reasons.NONE);
            this.broadcast().registersUpdated(this.getProxy(), values);
            seq.exit();
        }).finish();
    }

    default public Map<String, byte[]> getCachedRegisters() {
        return this.getValues();
    }

    default public Map<String, byte[]> getValues() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry entry : this.getCachedAttributes().entrySet()) {
            if (!(entry.getValue() instanceof DbgModelTargetRegister)) continue;
            DbgModelTargetRegister reg = (DbgModelTargetRegister)entry.getValue();
            byte[] bytes = reg.getBytes();
            result.put((String)entry.getKey(), bytes);
        }
        return result;
    }
}

