/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointContainer;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointSpec;
import agent.dbgeng.model.impl.DbgModelTargetBreakpointContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.util.datastruct.ListenerSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="BreakpointSpec", attributes={@TargetAttributeType(name="_container", type=DbgModelTargetBreakpointContainerImpl.class), @TargetAttributeType(name="_spec", type=DbgModelTargetBreakpointSpecImpl.class), @TargetAttributeType(name="Type", type=String.class), @TargetAttributeType(name="Disposition", type=String.class), @TargetAttributeType(name="Pending", type=String.class), @TargetAttributeType(name="Times", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetBreakpointSpecImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetBreakpointSpec {
    protected DbgBreakpointInfo info;
    protected boolean enabled;
    private final ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = new ListenerSet(TargetBreakpointSpec.TargetBreakpointAction.class, false);

    protected static String indexBreakpoint(DbgBreakpointInfo info) {
        return PathUtils.makeIndex((long)info.getNumber());
    }

    protected static String keyBreakpoint(DbgBreakpointInfo info) {
        return PathUtils.makeKey((String)DbgModelTargetBreakpointSpecImpl.indexBreakpoint(info));
    }

    public void changeAttributeSet(String reason) {
        this.changeAttributes(List.of(), List.of(), Map.of("_display", "[" + this.info.getNumber() + "] " + this.info.getExpression(), "_range", this.doGetRange(), "_spec", this, "_expression", this.info.getExpression(), "_kinds", this.getKinds(), "Type", this.info.getType().name(), "Disposition", this.info.getDisp().name(), "Pending", this.info.getPending(), "Times", this.info.getTimes()), reason);
    }

    public DbgModelTargetBreakpointSpecImpl(DbgModelTargetBreakpointContainer breakpoints, DbgBreakpointInfo info) {
        super(breakpoints.getModel(), (TargetObject)breakpoints, DbgModelTargetBreakpointSpecImpl.keyBreakpoint(info), "BreakpointSpec");
        this.getModel().addModelObject(info.getDebugBreakpoint(), (TargetObject)this);
        this.updateInfo(null, info, "Created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInfo(DbgBreakpointInfo oldInfo, DbgBreakpointInfo newInfo, String reason) {
        DbgModelTargetBreakpointSpecImpl dbgModelTargetBreakpointSpecImpl = this;
        synchronized (dbgModelTargetBreakpointSpecImpl) {
            assert (oldInfo == this.getBreakpointInfo());
            this.setBreakpointInfo(newInfo);
        }
        this.changeAttributeSet("Refreshed");
        this.setEnabled(newInfo.isEnabled(), reason);
    }

    @Override
    public DbgBreakpointInfo getBreakpointInfo() {
        return this.info;
    }

    @Override
    public void setBreakpointId(String id) {
        throw new AssertionError();
    }

    @Override
    public void setBreakpointInfo(DbgBreakpointInfo info) {
        this.info = info;
    }

    @Override
    public void setEnabled(boolean enabled, String reason) {
        this.setBreakpointEnabled(enabled);
        this.changeAttributes(List.of(), List.of(), Map.of("_enabled", enabled), reason);
    }

    @Override
    public boolean isBreakpointEnabled() {
        return this.enabled;
    }

    @Override
    public void setBreakpointEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> getActions() {
        return this.actions;
    }

    protected CompletableFuture<DbgBreakpointInfo> getInfo() {
        return this.getManager().listBreakpoints().thenApply(__ -> this.getManager().getKnownBreakpoints().get(this.getNumber()));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getInfo().thenAccept(i -> {
            DbgModelTargetBreakpointSpecImpl dbgModelTargetBreakpointSpecImpl = this;
            synchronized (dbgModelTargetBreakpointSpecImpl) {
                this.setBreakpointInfo((DbgBreakpointInfo)i);
            }
            this.changeAttributeSet("Initialized");
        });
    }
}

