/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface1.DbgModelTargetConfigurable;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetModuleContainer;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetProcessContainer;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetProcessImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ProcessContainer", elements={@TargetElementType(type=DbgModelTargetProcessImpl.class)}, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(name="Populate", type=TargetMethod.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetProcessContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetProcessContainer,
DbgModelTargetConfigurable {
    public DbgModelTargetProcessContainerImpl(DbgModelTargetSession session) {
        super(session.getModel(), (TargetObject)session, "Processes", "ProcessContainer");
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
        DbgManagerImpl manager = this.getManager();
        manager.addEventsListener(this);
    }

    @Override
    public void processAdded(DbgProcess proc, DbgCause cause) {
        DbgModelTargetSession session = (DbgModelTargetSession)this.getParent();
        session.setAccessible(true);
        DbgModelTargetProcess process = this.getTargetProcess(proc);
        this.changeElements(List.of(), List.of(process), Map.of(), "Added");
        process.processStarted((long)proc.getPid());
        this.broadcast().event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_CREATED, "Process " + proc.getId() + " started " + process.getName() + "pid=" + proc.getPid(), List.of(process));
        DbgManagerImpl manager = this.getManager();
        if (manager.isKernelMode()) {
            this.changeAttributes(List.of(), List.of(), TargetMethod.AnnotatedTargetMethod.collectExports((MethodHandles.Lookup)MethodHandles.lookup(), (AbstractDebuggerObjectModel)this.getModel(), (TargetObject)this), "Methods");
        }
    }

    @Override
    public void processStarted(DbgProcess proc, DbgCause cause) {
        DbgModelTargetProcess process = this.getTargetProcess(proc);
        process.processStarted((long)proc.getPid());
    }

    @Override
    public void processRemoved(DebugProcessId processId, DbgCause cause) {
        this.changeElements(List.of(DbgModelTargetProcessImpl.indexProcess(processId)), List.of(), Map.of(), "Removed");
    }

    @Override
    public void threadCreated(DbgThread thread, DbgCause cause) {
        DbgModelTargetProcess process = this.getTargetProcess(thread.getProcess());
        process.getThreads().threadCreated(thread);
    }

    @Override
    public void threadStateChanged(DbgThread thread, DbgState state, DbgCause cause, DbgReason reason) {
        DbgModelTargetMemoryContainer memory;
        DbgModelTargetProcess process = this.getTargetProcess(thread.getProcess());
        process.threadStateChangedSpecific(thread, state);
        if (!this.getManager().getStatus().equals((Object)DebugClient.DebugStatus.STEP_INTO) && (memory = process.getMemory()) != null) {
            memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
    }

    @Override
    public void threadExited(DebugThreadId threadId, DbgProcess proc, DbgCause cause) {
        DbgModelTargetProcess process = this.getTargetProcess(proc);
        if (process != null) {
            process.getThreads().threadExited(threadId);
        }
    }

    @Override
    public void breakpointHit(DbgBreakpointInfo info, DbgCause cause) {
        DbgProcess proc = info.getProc();
        DbgModelTargetProcess process = this.getTargetProcess(proc);
        DbgModelTargetMemoryContainer memory = process.getMemory();
        if (memory != null) {
            memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
    }

    @Override
    public void moduleLoaded(DbgProcess proc, DebugModuleInfo info, DbgCause cause) {
        DbgModelTargetMemoryContainer memory;
        DbgModelTargetProcess process = this.getTargetProcess(proc);
        DbgModelTargetModuleContainer modules = process.getModules();
        if (modules != null) {
            modules.libraryLoaded(info.toString());
        }
        if ((memory = process.getMemory()) != null) {
            memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
    }

    @Override
    public void moduleUnloaded(DbgProcess proc, DebugModuleInfo info, DbgCause cause) {
        DbgModelTargetProcess process = this.getTargetProcess(proc);
        process.getModules().libraryUnloaded(info.toString());
        DbgModelTargetMemoryContainer memory = process.getMemory();
        if (memory != null) {
            memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
        }
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        DbgManagerImpl manager = this.getManager();
        return manager.listProcesses().thenAccept(byIID -> {
            List processes;
            DbgModelTargetProcessContainerImpl dbgModelTargetProcessContainerImpl = this;
            synchronized (dbgModelTargetProcessContainerImpl) {
                processes = byIID.values().stream().map(this::getTargetProcess).collect(Collectors.toList());
            }
            this.setElements(processes, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized DbgModelTargetProcess getTargetProcess(DebugProcessId id) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(id);
        if (modelObject != null) {
            return (DbgModelTargetProcess)modelObject;
        }
        return new DbgModelTargetProcessImpl(this, this.getManager().getKnownProcesses().get(id));
    }

    @Override
    public synchronized DbgModelTargetProcess getTargetProcess(DbgProcess process) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(process);
        if (modelObject != null) {
            return (DbgModelTargetProcess)modelObject;
        }
        return new DbgModelTargetProcessImpl(this, process);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (TargetObject child : this.getCachedElements().values()) {
                        if (!(child instanceof DbgModelTargetProcessImpl)) continue;
                        DbgModelTargetProcessImpl targetProcess = (DbgModelTargetProcessImpl)child;
                        targetProcess.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.nil();
    }

    @TargetMethod.Export(value="Populate")
    public CompletableFuture<Void> populate() {
        return this.getManager().listOSProcesses().thenAccept(byPID -> {
            List processes;
            DbgModelTargetProcessContainerImpl dbgModelTargetProcessContainerImpl = this;
            synchronized (dbgModelTargetProcessContainerImpl) {
                processes = byPID.values().stream().map(this::getTargetProcess).collect(Collectors.toList());
            }
            this.setElements(processes, Map.of(), "Refreshed");
        });
    }
}

