/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.impl.DbgMinimalSymbol;
import agent.dbgeng.model.iface2.DbgModelTargetSymbol;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetSymbolContainerImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Symbol", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_namespace", type=DbgModelTargetSymbolContainerImpl.class), @TargetAttributeType(name="_value", type=Address.class), @TargetAttributeType(name="_size", type=long.class), @TargetAttributeType(name="_bpt", type=String.class), @TargetAttributeType(name="Name", type=String.class), @TargetAttributeType(name="Size", type=long.class), @TargetAttributeType(name="TypeId", type=int.class), @TargetAttributeType(name="Tag", type=int.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetSymbolImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetSymbol {
    protected final boolean constant;
    protected final Address value;
    protected final long size;

    protected static String indexSymbol(DbgMinimalSymbol symbol) {
        return symbol.getName();
    }

    protected static String keySymbol(DbgMinimalSymbol symbol) {
        return PathUtils.makeKey((String)DbgModelTargetSymbolImpl.indexSymbol(symbol));
    }

    public DbgModelTargetSymbolImpl(DbgModelTargetSymbolContainerImpl symbols, DbgMinimalSymbol symbol) {
        super(symbols.getModel(), (TargetObject)symbols, DbgModelTargetSymbolImpl.keySymbol(symbol), "Symbol");
        this.getModel().addModelObject(symbol, (TargetObject)this);
        this.constant = false;
        this.value = symbols.getModel().getAddressSpace("ram").getAddress(symbol.getAddress());
        this.size = symbol.getSize();
        TargetObject module = symbols.getParent();
        String moduleName = (String)module.getCachedAttribute("_short_display");
        this.changeAttributes(List.of(), List.of(), Map.of("_namespace", symbols, "_value", this.value, "_size", this.size, "_bpt", moduleName + "!" + symbol.getName(), "Name", symbol.getName(), "Size", this.size, "TypeId", symbol.getTypeId(), "Tag", symbol.getTag()), "Initialized");
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public Address getValue() {
        return this.value;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

