/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.lldb;

import SWIG.BreakpointEventType;
import SWIG.SBAttachInfo;
import SWIG.SBBreakpoint;
import SWIG.SBCommandInterpreter;
import SWIG.SBCommandReturnObject;
import SWIG.SBDebugger;
import SWIG.SBError;
import SWIG.SBEvent;
import SWIG.SBLaunchInfo;
import SWIG.SBListener;
import SWIG.SBProcess;
import SWIG.SBStream;
import SWIG.SBTarget;
import SWIG.SBThread;
import SWIG.SBWatchpoint;
import SWIG.StateType;
import SWIG.WatchpointEventType;
import agent.lldb.lldb.DebugBreakpointInfo;
import agent.lldb.lldb.DebugClient;
import agent.lldb.lldb.DebugEventInfo;
import agent.lldb.lldb.DebugModuleInfo;
import agent.lldb.lldb.DebugOutputCallbacks;
import agent.lldb.lldb.DebugProcessInfo;
import agent.lldb.lldb.DebugServerId;
import agent.lldb.lldb.DebugThreadInfo;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.LldbManager;
import agent.lldb.manager.evt.LldbBreakpointAutoContinueChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointCommandChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointConditionChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointCreatedEvent;
import agent.lldb.manager.evt.LldbBreakpointDeletedEvent;
import agent.lldb.manager.evt.LldbBreakpointDisabledEvent;
import agent.lldb.manager.evt.LldbBreakpointEnabledEvent;
import agent.lldb.manager.evt.LldbBreakpointIgnoreChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointInvalidatedEvent;
import agent.lldb.manager.evt.LldbBreakpointLocationsAddedEvent;
import agent.lldb.manager.evt.LldbBreakpointLocationsRemovedEvent;
import agent.lldb.manager.evt.LldbBreakpointLocationsResolvedEvent;
import agent.lldb.manager.evt.LldbBreakpointModifiedEvent;
import agent.lldb.manager.evt.LldbBreakpointThreadChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointTypeChangedEvent;
import agent.lldb.manager.evt.LldbConsoleOutputEvent;
import agent.lldb.manager.evt.LldbInterruptEvent;
import agent.lldb.manager.evt.LldbModuleLoadedEvent;
import agent.lldb.manager.evt.LldbModuleUnloadedEvent;
import agent.lldb.manager.evt.LldbProfileDataEvent;
import agent.lldb.manager.evt.LldbSelectedFrameChangedEvent;
import agent.lldb.manager.evt.LldbStateChangedEvent;
import agent.lldb.manager.evt.LldbStructuredDataEvent;
import agent.lldb.manager.evt.LldbSymbolsLoadedEvent;
import agent.lldb.manager.evt.LldbThreadResumedEvent;
import agent.lldb.manager.evt.LldbThreadSelectedEvent;
import agent.lldb.manager.evt.LldbThreadStackChangedEvent;
import agent.lldb.manager.evt.LldbThreadSuspendedEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.util.Msg;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DebugClientImpl
implements DebugClient {
    private LldbManager manager;
    private SBDebugger sbd;
    private SBTarget session;
    private SBEvent event;
    private DebugOutputCallbacks ocb;
    private SBCommandInterpreter cmd;
    private boolean sessionsAreImmutable;

    @Override
    public DebugClient createClient() {
        SBError error = SBDebugger.InitializeWithErrorHandling();
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
            return null;
        }
        this.event = new SBEvent();
        this.sbd = SBDebugger.Create();
        this.cmd = this.sbd.GetCommandInterpreter();
        return this;
    }

    public SBDebugger getDebugger() {
        return this.sbd;
    }

    @Override
    public SBListener getListener() {
        return this.sbd.GetListener();
    }

    @Override
    public DebugServerId getLocalServer() {
        return new DebugServerId(0L);
    }

    @Override
    public SBProcess attachProcess(DebugServerId si, int keyType, String key, boolean wait, boolean async) {
        SBProcess process;
        SBListener listener = new SBListener();
        SBError error = new SBError();
        this.session = this.createNullSession();
        switch (keyType) {
            case 0: {
                int radix = 10;
                if (key.startsWith("0x")) {
                    key = key.substring(2);
                    radix = 16;
                }
                BigInteger processId = new BigInteger(key, radix);
                process = this.session.AttachToProcessWithID(listener, processId, error);
                break;
            }
            case 1: {
                process = this.session.AttachToProcessWithName(listener, key, wait, error);
                break;
            }
            case 2: {
                SBAttachInfo info = new SBAttachInfo(key, wait, async);
                process = this.session.Attach(info, error);
                break;
            }
            default: {
                return null;
            }
        }
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(error.GetType() + " while attaching to " + key));
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
            return null;
        }
        if (async) {
            this.manager.waitForEventEx();
        } else {
            this.manager.updateState(process);
        }
        return process;
    }

    @Override
    public SBProcess connectRemote(DebugServerId si, String key, boolean auto, boolean async, boolean kernel) {
        SBListener listener = new SBListener();
        SBError error = new SBError();
        if (!auto) {
            this.session = this.createNullSession();
            ((LldbManagerImpl)this.manager).addSessionIfAbsent(this.session);
            return null;
        }
        String plugin = kernel ? "kdb-remote" : "gdb-remote";
        this.session = this.connectSession("");
        SBProcess process = this.session.ConnectRemote(listener, key, plugin, error);
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(error.GetType() + " while attaching to " + key));
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
            return null;
        }
        if (async) {
            this.manager.waitForEventEx();
        } else {
            this.manager.updateState(process);
        }
        this.sessionsAreImmutable = true;
        return process;
    }

    @Override
    public SBProcess createProcess(DebugServerId si, String fileName) {
        return this.createProcess(si, fileName, new ArrayList<String>(), new ArrayList<String>(), "");
    }

    @Override
    public SBProcess createProcess(DebugServerId si, String fileName, List<String> args, List<String> envp, String workingDir) {
        SBError error = new SBError();
        this.session = this.connectSession(fileName);
        String[] argArr = args.toArray(new String[args.size()]);
        String[] envArr = envp.isEmpty() ? null : envp.toArray(new String[envp.size()]);
        SBProcess process = this.session.LaunchSimple(argArr, envArr, workingDir);
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(error.GetType() + " for create process"));
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
            return null;
        }
        this.manager.updateState(process);
        return process;
    }

    @Override
    public SBProcess createProcess(DebugServerId si, SBLaunchInfo info) {
        SBError error = new SBError();
        Object cmd = info.GetExecutableFile().GetDirectory();
        cmd = (String)cmd + "/" + info.GetExecutableFile().GetFilename();
        int i = 0;
        while ((long)i < info.GetNumArguments()) {
            cmd = (String)cmd + " " + info.GetArgumentAtIndex((long)i);
            ++i;
        }
        this.session = this.connectSession((String)cmd);
        SBProcess process = this.session.Launch(info, error);
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(error.GetType() + " for create process"));
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
            return null;
        }
        return process;
    }

    @Override
    public SBProcess createProcess(DebugServerId si, String fileName, List<String> args, List<String> envp, List<String> pathsIO, String workingDir, long createFlags, boolean stopAtEntry) {
        File f = new File(fileName);
        this.session = this.connectSession(f.getAbsolutePath());
        String[] argArr = args.toArray(new String[args.size()]);
        String[] envArr = envp.isEmpty() ? null : envp.toArray(new String[envp.size()]);
        String pathSTDIN = pathsIO.get(0);
        String pathSTDOUT = pathsIO.get(1);
        String pathSTDERR = pathsIO.get(2);
        SBListener listener = new SBListener();
        SBError error = new SBError();
        SBProcess process = this.session.Launch(listener, argArr, envArr, pathSTDIN, pathSTDOUT, pathSTDERR, workingDir, createFlags, stopAtEntry, error);
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(error.GetType() + " while launching " + fileName));
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
            return null;
        }
        if (stopAtEntry) {
            this.manager.updateState(process);
        } else {
            this.manager.waitForEventEx();
        }
        return process;
    }

    @Override
    public void terminateCurrentProcess() {
        SBProcess process = this.session.GetProcess();
        SBError error = process.Kill();
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
        }
    }

    @Override
    public void destroyCurrentProcess() {
        SBProcess process = this.session.GetProcess();
        SBError error = process.Destroy();
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
        }
    }

    @Override
    public void detachCurrentProcess() {
        SBProcess process = this.session.GetProcess();
        SBError error = process.Detach();
        if (!error.Success()) {
            SBStream stream = new SBStream();
            error.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
        }
    }

    public SBTarget createNullSession() {
        return this.sbd.GetDummyTarget();
    }

    @Override
    public SBTarget connectSession(String fileName) {
        return this.sbd.CreateTarget(fileName);
    }

    @Override
    public Map<String, SBTarget> listSessions() {
        if (this.isSessionImmutable()) {
            return this.manager.getKnownSessions();
        }
        HashMap<String, SBTarget> map = new HashMap<String, SBTarget>();
        int i = 0;
        while ((long)i < this.sbd.GetNumTargets()) {
            SBTarget target = this.sbd.GetTargetAtIndex((long)i);
            map.put(DebugClient.getId(target), target);
            ++i;
        }
        return map;
    }

    @Override
    public void endSession(DebugClient.DebugEndSessionFlags flags) {
        this.sbd.DeleteTarget(this.session);
    }

    @Override
    public void openDumpFileWide(String fileName) {
        SBError error = new SBError();
        this.session.LoadCore(fileName, error);
        if (!error.Success()) {
            Msg.error((Object)this, (Object)(error.GetType() + " while loading " + fileName));
        }
    }

    @Override
    public SBEvent waitForEvent() {
        boolean eventFound = this.getListener().WaitForEvent(-1L, this.event);
        if (eventFound) {
            return this.event;
        }
        return null;
    }

    public void translateAndFireEvent(SBEvent evt) {
        DebugBreakpointInfo info;
        Object info2;
        this.manager.setCurrentEvent(evt);
        long type = evt.GetType();
        if (SBTarget.EventIsTargetEvent((SBEvent)evt)) {
            if ((type & (long)SBTarget.eBroadcastBitBreakpointChanged) != 0L) {
                Msg.info((Object)this, (Object)("*** Breakpoint Changed: " + evt.GetType()));
                SBBreakpoint bpt = SBBreakpoint.GetBreakpointFromEvent((SBEvent)evt);
                this.processEvent(new LldbBreakpointModifiedEvent(new DebugBreakpointInfo(evt, bpt)));
            }
            if ((type & (long)SBTarget.eBroadcastBitModulesLoaded) != 0L) {
                Msg.info((Object)this, (Object)("*** Module Loaded: " + evt.GetType()));
                this.processEvent(new LldbModuleLoadedEvent(new DebugModuleInfo(evt)));
            }
            if ((type & (long)SBTarget.eBroadcastBitModulesUnloaded) != 0L) {
                Msg.info((Object)this, (Object)("*** Module Unloaded: " + evt.GetType()));
                this.processEvent(new LldbModuleUnloadedEvent(new DebugModuleInfo(evt)));
            }
            if ((type & (long)SBTarget.eBroadcastBitWatchpointChanged) != 0L) {
                Msg.info((Object)this, (Object)("*** Watchpoint Changed: " + evt.GetType()));
                SBWatchpoint wpt = SBWatchpoint.GetWatchpointFromEvent((SBEvent)evt);
                this.processEvent(new LldbBreakpointModifiedEvent(new DebugBreakpointInfo(evt, wpt)));
            }
            if ((type & (long)SBTarget.eBroadcastBitSymbolsLoaded) != 0L) {
                Msg.info((Object)this, (Object)("*** Symbols Loaded: " + evt.GetType()));
                this.processEvent(new LldbSymbolsLoadedEvent(new DebugEventInfo(evt)));
            }
        }
        if (SBProcess.EventIsProcessEvent((SBEvent)evt)) {
            info2 = new DebugProcessInfo(evt);
            if ((type & (long)SBProcess.eBroadcastBitStateChanged) != 0L) {
                Msg.info((Object)this, (Object)("*** State Changed: " + evt.GetType()));
                this.processEvent(new LldbStateChangedEvent((DebugProcessInfo)info2));
            }
            if ((type & (long)SBProcess.eBroadcastBitInterrupt) != 0L) {
                Msg.info((Object)this, (Object)("*** Interrupt: " + evt.GetType()));
                this.processEvent(new LldbInterruptEvent((DebugProcessInfo)info2));
            }
            if ((type & (long)SBProcess.eBroadcastBitSTDOUT) != 0L) {
                Msg.info((Object)this, (Object)("*** Console STDOUT: " + evt.GetType()));
                this.processEvent(new LldbConsoleOutputEvent((DebugProcessInfo)info2));
            }
            if ((type & (long)SBProcess.eBroadcastBitSTDERR) != 0L) {
                Msg.info((Object)this, (Object)("*** Console STDERR: " + evt.GetType()));
                this.processEvent(new LldbConsoleOutputEvent((DebugProcessInfo)info2));
            }
            if ((type & (long)SBProcess.eBroadcastBitProfileData) != 0L) {
                Msg.info((Object)this, (Object)("*** Profile Data Added: " + evt.GetType()));
                this.processEvent(new LldbProfileDataEvent((DebugProcessInfo)info2));
            }
            if ((type & (long)SBProcess.eBroadcastBitStructuredData) != 0L) {
                Msg.info((Object)this, (Object)("*** Structured Data Added: " + evt.GetType()));
                this.processEvent(new LldbStructuredDataEvent((DebugProcessInfo)info2));
            }
        }
        if (SBThread.EventIsThreadEvent((SBEvent)evt)) {
            info2 = new DebugThreadInfo(evt);
            if ((type & (long)SBThread.eBroadcastBitStackChanged) != 0L) {
                Msg.info((Object)this, (Object)("*** Stack Changed: " + evt.GetType()));
                this.processEvent(new LldbThreadStackChangedEvent((DebugThreadInfo)info2));
            }
            if ((type & (long)SBThread.eBroadcastBitThreadSuspended) != 0L) {
                Msg.info((Object)this, (Object)("*** Thread Suspended: " + evt.GetType()));
                this.processEvent(new LldbThreadSuspendedEvent((DebugThreadInfo)info2));
            }
            if ((type & (long)SBThread.eBroadcastBitThreadResumed) != 0L) {
                Msg.info((Object)this, (Object)("*** Thread Resumed: " + evt.GetType()));
                this.processEvent(new LldbThreadResumedEvent((DebugThreadInfo)info2));
            }
            if ((type & (long)SBThread.eBroadcastBitSelectedFrameChanged) != 0L) {
                Msg.info((Object)this, (Object)("*** Frame Selected: " + evt.GetType()));
                this.processEvent(new LldbSelectedFrameChangedEvent((DebugThreadInfo)info2));
            }
            if ((type & (long)SBThread.eBroadcastBitThreadSelected) != 0L) {
                Msg.info((Object)this, (Object)("*** Thread Selected: " + evt.GetType()));
                this.processEvent(new LldbThreadSelectedEvent((DebugThreadInfo)info2));
            }
        }
        if (SBBreakpoint.EventIsBreakpointEvent((SBEvent)evt)) {
            BreakpointEventType btype = SBBreakpoint.GetBreakpointEventTypeFromEvent((SBEvent)evt);
            SBBreakpoint bpt = SBBreakpoint.GetBreakpointFromEvent((SBEvent)evt);
            info = new DebugBreakpointInfo(evt, bpt);
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeAdded)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Added: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointCreatedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeAutoContinueChanged)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Auto Continue: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointAutoContinueChangedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeCommandChanged)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Command Changed: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointCommandChangedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeConditionChanged)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Condition Changed: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointConditionChangedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeDisabled)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Disabled: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointDisabledEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeEnabled)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Enabled: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointEnabledEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeIgnoreChanged)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Ignore Changed: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointIgnoreChangedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeInvalidType)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Invalid Type: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointInvalidatedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeLocationsAdded)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Locations Added: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointLocationsAddedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeLocationsRemoved)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Locations Removed: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointLocationsRemovedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeLocationsResolved)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Locations Resolved: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointLocationsResolvedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeRemoved)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Removed: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointDeletedEvent(info));
            }
            if (btype.equals(BreakpointEventType.eBreakpointEventTypeThreadChanged)) {
                Msg.info((Object)this, (Object)("*** Breakpoint Thread Changed: " + bpt.GetID()));
                this.processEvent(new LldbBreakpointThreadChangedEvent(info));
            }
        }
        if (SBWatchpoint.EventIsWatchpointEvent((SBEvent)evt)) {
            WatchpointEventType wtype = SBWatchpoint.GetWatchpointEventTypeFromEvent((SBEvent)evt);
            SBWatchpoint wpt = SBWatchpoint.GetWatchpointFromEvent((SBEvent)evt);
            info = new DebugBreakpointInfo(evt, wpt);
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeAdded)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Added: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointCreatedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeCommandChanged)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Command Changed: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointCommandChangedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeConditionChanged)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Condition Changed: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointConditionChangedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeDisabled)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Disabled: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointDisabledEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeEnabled)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Enabled: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointEnabledEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeIgnoreChanged)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Ignore Changed: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointIgnoreChangedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeInvalidType)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Invalid Type: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointInvalidatedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeRemoved)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Removed: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointDeletedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeThreadChanged)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Thread Changed: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointThreadChangedEvent(info));
            }
            if (wtype.equals(WatchpointEventType.eWatchpointEventTypeTypeChanged)) {
                Msg.info((Object)this, (Object)("*** Watchpoint Type Changed: " + wpt.GetID()));
                this.processEvent(new LldbBreakpointTypeChangedEvent(info));
            }
        }
    }

    @Override
    public void processEvent(LldbEvent<?> lldbEvt) {
        this.manager.processEvent(lldbEvt);
    }

    @Override
    public DebugClient.DebugStatus getExecutionStatus() {
        StateType state = this.manager.getState();
        return DebugClient.DebugStatus.fromArgument(state);
    }

    @Override
    public void setOutputCallbacks(DebugOutputCallbacks cb) {
        this.ocb = cb;
    }

    @Override
    public boolean getInterrupt() {
        return false;
    }

    @Override
    public void setManager(LldbManager manager) {
        this.manager = manager;
    }

    @Override
    public void addBroadcaster(Object object) {
        if (object instanceof SBCommandInterpreter) {
            SBCommandInterpreter interpreter = (SBCommandInterpreter)object;
            interpreter.GetBroadcaster().AddListener(this.getListener(), DebugClient.ChangeSessionState.SESSION_ALL.getMask());
        }
        if (object instanceof SBTarget) {
            SBTarget session = (SBTarget)object;
            session.GetBroadcaster().AddListener(this.getListener(), DebugClient.ChangeSessionState.SESSION_ALL.getMask());
        }
        if (object instanceof SBProcess) {
            SBProcess process = (SBProcess)object;
            process.GetBroadcaster().AddListener(this.getListener(), DebugClient.ChangeProcessState.PROCESS_ALL.getMask());
        }
    }

    @Override
    public void execute(String command) {
        SBCommandReturnObject res = new SBCommandReturnObject();
        this.cmd.HandleCommand(command, res);
        if (res.GetErrorSize() > 0L) {
            this.ocb.output(DebugClient.DebugOutputFlags.DEBUG_OUTPUT_ERROR.ordinal(), res.GetError());
        }
        if (res.GetOutputSize() > 0L) {
            this.ocb.output(DebugClient.DebugOutputFlags.DEBUG_OUTPUT_NORMAL.ordinal(), res.GetOutput());
        }
    }

    public boolean isSessionImmutable() {
        return this.sessionsAreImmutable;
    }
}

