/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager;

import SWIG.SBBreakpoint;
import SWIG.SBBreakpointLocation;
import SWIG.SBEvent;
import SWIG.SBFrame;
import SWIG.SBMemoryRegionInfo;
import SWIG.SBModule;
import SWIG.SBProcess;
import SWIG.SBSection;
import SWIG.SBSymbol;
import SWIG.SBTarget;
import SWIG.SBThread;
import SWIG.SBValue;
import SWIG.StateType;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCommand;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.LldbEventsListener;
import agent.lldb.manager.LldbStateListener;
import agent.lldb.manager.breakpoint.LldbBreakpointInsertions;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;

public interface LldbManager
extends AutoCloseable,
LldbBreakpointInsertions {
    public static LldbManager newInstance() {
        return new LldbManagerImpl();
    }

    public CompletableFuture<Void> start(String[] var1);

    public void terminate();

    public boolean isRunning();

    public void addStateListener(LldbStateListener var1);

    public void removeStateListener(LldbStateListener var1);

    public void addEventsListener(LldbEventsListener var1);

    public void removeEventsListener(LldbEventsListener var1);

    public SBThread getThread(SBProcess var1, String var2);

    public SBProcess getProcess(SBTarget var1, String var2);

    public SBTarget getSession(String var1);

    public SBModule getModule(SBTarget var1, String var2);

    public Map<String, SBThread> getKnownThreads(SBProcess var1);

    public Map<String, SBProcess> getKnownProcesses(SBTarget var1);

    public Map<String, SBTarget> getKnownSessions();

    public Map<String, SBModule> getKnownModules(SBTarget var1);

    public Map<String, Object> getKnownBreakpoints(SBTarget var1);

    public void sendInterruptNow();

    public StateType getState();

    public CompletableFuture<SBProcess> addProcess();

    public CompletableFuture<Void> removeProcess(SBProcess var1);

    public CompletableFuture<SBTarget> addSession();

    public CompletableFuture<Void> console(String var1);

    public CompletableFuture<String> consoleCapture(String var1);

    public CompletableFuture<Map<String, SBThread>> listThreads(SBProcess var1);

    public CompletableFuture<Map<String, SBProcess>> listProcesses(SBTarget var1);

    public CompletableFuture<List<Pair<String, String>>> listAvailableProcesses();

    public CompletableFuture<Map<String, SBTarget>> listSessions();

    public CompletableFuture<Map<String, SBFrame>> listStackFrames(SBThread var1);

    public CompletableFuture<Map<String, SBValue>> listStackFrameRegisterBanks(SBFrame var1);

    public CompletableFuture<Map<String, SBValue>> listStackFrameRegisters(SBValue var1);

    public CompletableFuture<Map<String, SBModule>> listModules(SBTarget var1);

    public CompletableFuture<Map<String, SBSection>> listModuleSections(SBModule var1);

    public CompletableFuture<Map<String, SBSymbol>> listModuleSymbols(SBModule var1);

    public CompletableFuture<List<SBMemoryRegionInfo>> listMemory(SBProcess var1);

    public CompletableFuture<Map<String, Object>> listBreakpoints(SBTarget var1);

    public CompletableFuture<Map<String, SBBreakpointLocation>> listBreakpointLocations(SBBreakpoint var1);

    public CompletableFuture<Map<String, String>> listEnvironment(SBTarget var1);

    public CompletableFuture<Void> disableBreakpoints(String ... var1);

    public CompletableFuture<Void> enableBreakpoints(String ... var1);

    public CompletableFuture<Void> deleteBreakpoints(String ... var1);

    public CompletableFuture<?> attach(String var1);

    public CompletableFuture<?> attach(String var1, boolean var2);

    public CompletableFuture<?> attach(String var1, boolean var2, boolean var3);

    public CompletableFuture<?> connect(String var1, boolean var2, boolean var3, boolean var4);

    public CompletableFuture<?> launch(String var1, List<String> var2);

    public CompletableFuture<?> launch(Map<String, ?> var1);

    public SBProcess currentProcess();

    public CompletableFuture<Void> waitForPrompt();

    public CompletableFuture<Void> waitForEventEx();

    public <T> CompletableFuture<T> execute(LldbCommand<? extends T> var1);

    public DebugClient.DebugStatus processEvent(LldbEvent<?> var1);

    public DebugClient.DebugStatus getStatus();

    public void setCurrentEvent(SBEvent var1);

    public void updateState(SBProcess var1);

    public static enum ExecSuffix {
        FINISH("finish"),
        NEXT("next"),
        NEXT_INSTRUCTION("next-instruction"),
        RETURN("return"),
        STEP("step"),
        STEP_INSTRUCTION("step-instruction"),
        UNTIL("until"),
        EXTENDED("ext");

        final String str;

        private ExecSuffix(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

