/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import agent.lldb.lldb.DebugClient;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.iface2.LldbModelTargetObject;
import agent.lldb.model.iface2.LldbModelTargetThread;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetObject;
import ghidra.util.datastruct.ListenerSet;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetBreakpointSpec
extends LldbModelTargetObject,
TargetBreakpointSpec,
TargetDeletable {
    public static final String BPT_ACCESS_ATTRIBUTE_NAME = "Access";
    public static final String BPT_DISP_ATTRIBUTE_NAME = "Enabled";
    public static final String BPT_VALID_ATTRIBUTE_NAME = "Valid";
    public static final String BPT_TIMES_ATTRIBUTE_NAME = "Count";
    public static final String BPT_TYPE_ATTRIBUTE_NAME = "Type";
    public static final String BPT_INDEX_ATTRIBUTE_NAME = "Id";

    default public CompletableFuture<Void> delete() {
        return this.getModel().gateFuture(this.getManager().deleteBreakpoints(this.getId()));
    }

    default public CompletableFuture<Void> disable() {
        this.setEnabled(false, "Disabled");
        return this.getModel().gateFuture(this.getManager().disableBreakpoints(this.getId()));
    }

    default public CompletableFuture<Void> enable() {
        this.setEnabled(true, BPT_DISP_ATTRIBUTE_NAME);
        return this.getModel().gateFuture(this.getManager().enableBreakpoints(this.getId()));
    }

    default public String getId() {
        return DebugClient.getId(this.getModelObject());
    }

    public TargetBreakpointSpecContainer.TargetBreakpointKindSet getKinds();

    public void updateInfo(Object var1, String var2);

    public void setEnabled(boolean var1, String var2);

    public ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> getActions();

    default public void addAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.getActions().add((Object)action);
    }

    default public void removeAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.getActions().remove((Object)action);
    }

    default public void breakpointHit() {
        LldbModelTargetThread targetThread = this.getParentProcess().getThreads().getTargetThread(this.getManager().getEventThread());
        ((TargetBreakpointSpec.TargetBreakpointAction)this.getActions().invoke()).breakpointHit((TargetBreakpointSpec)((LldbModelTargetBreakpointSpec)this.getProxy()), (TargetObject)targetThread, null, (TargetBreakpointLocation)this.findLocation(targetThread));
    }

    public LldbModelTargetBreakpointLocation findLocation(Object var1);
}

