/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBTarget;
import agent.lldb.manager.LldbCause;
import agent.lldb.model.iface2.LldbModelTargetRoot;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.iface2.LldbModelTargetSessionContainer;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetSessionImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SessionContainer", elements={@TargetElementType(type=LldbModelTargetSessionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetSessionContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetSessionContainer {
    public LldbModelTargetSessionContainerImpl(LldbModelTargetRoot root) {
        super(root.getModel(), (TargetObject)root, "Sessions", "SessionContainer");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void sessionAdded(SBTarget sess, LldbCause cause) {
        LldbModelTargetSession session = this.getTargetSession(sess);
        this.changeElements(List.of(), List.of(session), Map.of(), "Added");
    }

    @Override
    public void sessionReplaced(SBTarget sess, LldbCause cause) {
        LldbModelTargetSession session = this.getTargetSession(sess);
        this.changeElements(List.of(), List.of(session), Map.of(), "Replaced");
    }

    @Override
    public void sessionRemoved(String sessionId, LldbCause cause) {
        this.changeElements(List.of(sessionId), List.of(), Map.of(), "Removed");
    }

    @Override
    public synchronized LldbModelTargetSession getTargetSession(SBTarget session) {
        TargetObject targetObject = this.getMapObject(session);
        if (targetObject != null) {
            LldbModelTargetSession targetSession = (LldbModelTargetSession)targetObject;
            targetSession.setModelObject(session);
            return targetSession;
        }
        return new LldbModelTargetSessionImpl(this, session);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listSessions().thenAccept(byIID -> {
            List sessions;
            LldbModelTargetSessionContainerImpl lldbModelTargetSessionContainerImpl = this;
            synchronized (lldbModelTargetSessionContainerImpl) {
                sessions = byIID.values().stream().map(this::getTargetSession).collect(Collectors.toList());
            }
            this.setElements(sessions, "Refreshed");
        });
    }
}

