/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.datamodel.script;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelNameBinder;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelScriptProvider;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelScriptProviderEnumerator;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelNameBinderInternal;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptManagerInternal;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptProviderEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptProviderInternal;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.IDataModelScriptManager;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.WrapIDataModelNameBinder;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.WrapIDataModelScriptProvider;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.WrapIDataModelScriptProviderEnumerator;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DataModelScriptManagerImpl
implements DataModelScriptManagerInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDataModelScriptManager jnaData;

    public DataModelScriptManagerImpl(IDataModelScriptManager jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelNameBinder getDefaultNameBinder() {
        PointerByReference ppNameBinder = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetDefaultNameBinder(ppNameBinder));
        WrapIDataModelNameBinder wrap = new WrapIDataModelNameBinder(ppNameBinder.getValue());
        try {
            DataModelNameBinderInternal dataModelNameBinderInternal = DataModelNameBinderInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelNameBinderInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public void registerScriptProvider(DataModelScriptProvider provider) {
        Pointer pProvider = provider.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.RegisterScriptProvider(pProvider));
    }

    @Override
    public void unregisterScriptProvider(DataModelScriptProvider provider) {
        Pointer pProvider = provider.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.UnregisterScriptProvider(pProvider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelScriptProvider findProviderForScriptType(String scriptType) {
        WString wScriptType = new WString(scriptType);
        PointerByReference ppProvider = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.FindProviderForScriptType(wScriptType, ppProvider));
        WrapIDataModelScriptProvider wrap = new WrapIDataModelScriptProvider(ppProvider.getValue());
        try {
            DataModelScriptProviderInternal dataModelScriptProviderInternal = DataModelScriptProviderInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelScriptProviderInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelScriptProvider findProviderForScriptExtension(String scriptExtension) {
        WString wScriptExtension = new WString(scriptExtension);
        PointerByReference ppProvider = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.FindProviderForScriptType(wScriptExtension, ppProvider));
        WrapIDataModelScriptProvider wrap = new WrapIDataModelScriptProvider(ppProvider.getValue());
        try {
            DataModelScriptProviderInternal dataModelScriptProviderInternal = DataModelScriptProviderInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelScriptProviderInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelScriptProviderEnumerator enumeratorScriptProviders() {
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateScriptProviders(ppEnumerator));
        WrapIDataModelScriptProviderEnumerator wrap = new WrapIDataModelScriptProviderEnumerator(ppEnumerator.getValue());
        try {
            DataModelScriptProviderEnumeratorInternal dataModelScriptProviderEnumeratorInternal = DataModelScriptProviderEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelScriptProviderEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }
}

