/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInjectInfo;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;

@DisassemblyInjectInfo(compilers={})
public interface DisassemblyInject
extends ExtensionPoint {
    default public DisassemblyInjectInfo getInfo() {
        DisassemblyInjectInfo info = this.getClass().getAnnotation(DisassemblyInjectInfo.class);
        if (info == null) {
            Msg.warn((Object)this, (Object)(this.getClass() + " is missing @" + DisassemblyInjectInfo.class.getSimpleName() + " annotation"));
            return DisassemblyInject.class.getAnnotation(DisassemblyInjectInfo.class);
        }
        return info;
    }

    default public boolean isApplicable(Trace trace) {
        for (DisassemblyInjectInfo.CompilerInfo info : this.getInfo().compilers()) {
            if (!info.langID().equals(trace.getBaseLanguage().getLanguageID().toString()) || !info.compilerID().isBlank() && !info.compilerID().equals(trace.getBaseCompilerSpec().getCompilerSpecID().toString())) continue;
            return true;
        }
        return false;
    }

    default public int getPriority() {
        return this.getInfo().priority();
    }

    default public void pre(PluginTool tool, TraceDisassembleCommand command, Trace trace, Language language, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
    }

    default public void post(PluginTool tool, Trace trace, long snap, AddressSetView disassembled) {
    }
}

