/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.action.AutoMapSpec;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.modules.MapProposal;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ByModuleAutoMapSpec
implements AutoMapSpec {
    public static final String CONFIG_NAME = "1_MAP_BY_MODULE";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Auto-Map by Module";
    }

    @Override
    public Collection<TraceChangeType<?, ?>> getChangeTypes() {
        return List.of(Trace.TraceModuleChangeType.ADDED, Trace.TraceModuleChangeType.CHANGED, Trace.TraceMemoryRegionChangeType.ADDED, Trace.TraceMemoryRegionChangeType.CHANGED);
    }

    @Override
    public void performMapping(DebuggerStaticMappingService mappingService, Trace trace, ProgramManager programManager, TaskMonitor monitor) throws CancelledException {
        List<Program> programs = Arrays.asList(programManager.getAllOpenPrograms());
        Map maps = mappingService.proposeModuleMaps(trace.getModuleManager().getAllModules(), programs);
        Collection entries = MapProposal.flatten(maps.values());
        entries = MapProposal.removeOverlapping((Collection)entries);
        mappingService.addModuleMappings(entries, monitor, false);
    }
}

