/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.action.AutoMapSpec;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class OneToOneAutoMapSpec
implements AutoMapSpec {
    public static final String CONFIG_NAME = "2_MAP_ONE_TO_ONE";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Auto-Map Identically (1-to-1)";
    }

    @Override
    public Collection<TraceChangeType<?, ?>> getChangeTypes() {
        return List.of();
    }

    @Override
    public void performMapping(DebuggerStaticMappingService mappingService, Trace trace, ProgramManager programManager, TaskMonitor monitor) throws CancelledException {
        Program program = programManager.getCurrentProgram();
        if (program == null) {
            return;
        }
        try {
            mappingService.addIdentityMapping(trace, program, Lifespan.nowOn((long)trace.getProgramView().getSnap()), false);
        }
        catch (TraceConflictedMappingException traceConflictedMappingException) {
            // empty catch block
        }
    }
}

