/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.PCByRegisterLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCByStackLocationTrackingSpec;
import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.action.LocationTracker;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.util.TraceAddressSpace;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public enum PCLocationTrackingSpec implements LocationTrackingSpec,
LocationTracker
{
    INSTANCE;

    public static final String CONFIG_NAME = "TRACK_PC";
    private static final PCByRegisterLocationTrackingSpec BY_REG;
    private static final PCByStackLocationTrackingSpec BY_STACK;

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public String getMenuName() {
        return "Track Program Counter";
    }

    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_PC;
    }

    public String computeTitle(DebuggerCoordinates coordinates) {
        return "Auto PC";
    }

    public String getLocationLabel() {
        return "pc";
    }

    public LocationTracker getTracker() {
        return this;
    }

    public CompletableFuture<Address> computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        return CompletableFuture.supplyAsync(() -> {
            Address pc;
            if (coordinates.getTime().isSnapOnly() && (pc = BY_STACK.doComputeTraceAddress(tool, coordinates)) != null) {
                return pc;
            }
            return BY_REG.doComputeTraceAddress(tool, coordinates);
        });
    }

    public GoToInput getDefaultGoToInput(PluginTool tool, DebuggerCoordinates coordinates, ProgramLocation location) {
        return BY_REG.getDefaultGoToInput(tool, coordinates, location);
    }

    public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return BY_STACK.affectedByStackChange(stack, coordinates);
    }

    public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        return BY_REG.affectedByBytesChange(space, range, coordinates);
    }

    public boolean shouldDisassemble() {
        return true;
    }

    static {
        BY_REG = PCByRegisterLocationTrackingSpec.INSTANCE;
        BY_STACK = PCByStackLocationTrackingSpec.INSTANCE;
    }
}

