/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public class VisibleAutoReadMemorySpec
implements AutoReadMemorySpec {
    public static final String CONFIG_NAME = "1_READ_VISIBLE";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Read Visible Memory";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.AutoReadMemoryAction.ICON_VISIBLE;
    }

    @Override
    public CompletableFuture<Boolean> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
        if (!coordinates.isAliveAndReadsPresent()) {
            return CompletableFuture.completedFuture(false);
        }
        Target target = coordinates.getTarget();
        TraceMemoryManager mm = coordinates.getTrace().getMemoryManager();
        AddressSetView alreadyKnown = mm.getAddressesWithState(coordinates.getSnap(), visible, s -> s == TraceMemoryState.KNOWN);
        AddressSet toRead = visible.subtract(alreadyKnown);
        if (toRead.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        return target.readMemoryAsync((AddressSetView)toRead, TaskMonitor.DUMMY).thenApply(__ -> true);
    }
}

