/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import db.Transaction;
import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.model.GAddressRangeField;
import docking.widgets.model.GSpanField;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebuggerAddRegionDialog
extends ReusableDialogComponentProvider {
    private Trace trace;
    private final JTextField fieldName = new JTextField();
    private final GAddressRangeField fieldRange = new GAddressRangeField();
    private final JTextField fieldLength = new JTextField();
    private final GSpanField fieldLifespan = new GSpanField();

    public DebuggerAddRegionDialog() {
        super("Add Region", true, true, true, false);
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add(new JLabel("Name: "));
        panel.add(this.fieldName);
        panel.add(new JLabel("Range: "));
        panel.add((Component)this.fieldRange);
        panel.add(new JLabel("Length: "));
        this.fieldLength.setFont(Font.decode("monospaced"));
        panel.add(this.fieldLength);
        panel.add(new JLabel("Lifespan: "));
        panel.add((Component)this.fieldLifespan);
        MiscellaneousUtils.rigFocusAndEnter((Component)this.fieldRange, this::rangeChanged);
        MiscellaneousUtils.rigFocusAndEnter(this.fieldLength, this::lengthChanged);
        this.fieldLifespan.setLifespan(Lifespan.nowOn((long)0L));
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
    }

    protected static AddressRange range(Address min, long lengthMinus1) {
        return new AddressRangeImpl(min, min.addWrap(lengthMinus1));
    }

    public void setName(String name) {
        this.fieldName.setText(name);
    }

    protected void setFieldLength(long length) {
        this.fieldLength.setText(MiscellaneousUtils.lengthToString(length));
    }

    public long getLength() {
        return MiscellaneousUtils.parseLength(this.fieldLength.getText(), 1L);
    }

    protected void revalidateLength() {
        long length = this.fieldLength.getText().trim().startsWith("-") ? 1L : this.getLength();
        length = MiscellaneousUtils.revalidateLengthByRange(this.fieldRange.getRange(), length);
        this.setFieldLength(length);
    }

    protected void adjustLengthToRange() {
        AddressRange range = this.fieldRange.getRange();
        if (range == null) {
            return;
        }
        long length = range.getLength();
        this.setFieldLength(length);
    }

    protected void adjustRangeToLength() {
        AddressRange range = this.fieldRange.getRange();
        if (range == null) {
            return;
        }
        Address min = range.getMinAddress();
        this.fieldRange.setRange(DebuggerAddRegionDialog.range(min, this.getLength() - 1L));
    }

    protected void rangeChanged() {
        this.adjustLengthToRange();
    }

    protected void lengthChanged() {
        this.revalidateLength();
        this.adjustRangeToLength();
    }

    protected void dialogShown() {
        super.dialogShown();
        this.setStatusText("");
    }

    protected void cancelCallback() {
        this.setStatusText("");
        super.cancelCallback();
    }

    protected void okCallback() {
        this.addRegionAndClose();
    }

    protected void setValues(Trace trace, Lifespan lifespan) {
        this.trace = trace;
        AddressFactory af = trace.getBaseAddressFactory();
        this.fieldRange.setAddressFactory(af);
        this.fieldRange.setRange(DebuggerAddRegionDialog.range(af.getDefaultAddressSpace().getAddress(0L), 0L));
        this.fieldLength.setText("0x1");
        this.fieldLifespan.setLifespan(lifespan);
    }

    public void show(PluginTool tool, Trace trace, long snap) {
        this.setValues(trace, Lifespan.nowOn((long)snap));
        tool.showDialog((DialogComponentProvider)this);
    }

    public void close() {
        this.trace = null;
        this.fieldRange.setAddressFactory(null);
        super.close();
    }

    protected void addRegionAndClose() {
        try (Transaction tx = this.trace.openTransaction("Add region: " + this.fieldName);){
            this.trace.getMemoryManager().addRegion(this.fieldName.getText(), this.fieldLifespan.getLifespan(), this.fieldRange.getRange(), new TraceMemoryFlag[0]);
            this.close();
        }
        catch (TraceOverlappedRegionException | DuplicateNameException e) {
            this.setStatusText(e.getMessage());
        }
    }
}

