/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects;

import docking.ComponentProvider;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.ModelActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.ObjectUpdateService;
import ghidra.app.plugin.core.debug.gui.objects.ObjectUpdatedEvent;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerInterpreterService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.CollectionChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

@PluginInfo(shortDescription="Debugger objects manager", description="GUI to manage connections to external debuggers and trace recording", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramOpenedPluginEvent.class, ProgramSelectionPluginEvent.class, TraceActivatedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class, ModelActivatedPluginEvent.class}, servicesProvided={ObjectUpdateService.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerModelService.class, DebuggerInterpreterService.class})
public class DebuggerObjectsPlugin
extends AbstractDebuggerPlugin
implements ObjectUpdateService,
CollectionChangeListener<DebuggerObjectModel> {
    static String TITLE_PROVIDER_TARGETS = "Debugger Objects";
    @AutoServiceConsumed
    protected DebuggerInterpreterService interpreterService;
    @AutoServiceConsumed
    public DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    private List<DebuggerObjectsProvider> providers = new ArrayList<DebuggerObjectsProvider>();
    private Program activeProgram;
    private SaveState copiedSaveState = new SaveState();

    public DebuggerObjectsPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        try {
            ObjectContainer init = new ObjectContainer(null, null);
            DebuggerObjectsProvider p = new DebuggerObjectsProvider(this, null, init, true);
            p.readConfigState(this.copiedSaveState);
            init.propagateProvider(p);
            p.update(init);
            p.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.init();
    }

    protected void dispose() {
        this.providers.get(0).setVisible(true);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        block8: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    super.processEvent(event);
                                    if (!(event instanceof TraceOpenedPluginEvent)) break block7;
                                    TraceOpenedPluginEvent ev = (TraceOpenedPluginEvent)event;
                                    for (DebuggerObjectsProvider provider : this.providers) {
                                        provider.traceOpened(ev.getTrace());
                                    }
                                    break block8;
                                }
                                if (!(event instanceof TraceActivatedPluginEvent)) break block9;
                                TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
                                for (DebuggerObjectsProvider provider : this.providers) {
                                    provider.traceActivated(ev.getActiveCoordinates());
                                }
                                break block8;
                            }
                            if (!(event instanceof TraceClosedPluginEvent)) break block10;
                            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
                            for (DebuggerObjectsProvider provider : this.providers) {
                                provider.traceClosed(ev.getTrace());
                            }
                            break block8;
                        }
                        if (!(event instanceof ModelActivatedPluginEvent)) break block11;
                        ModelActivatedPluginEvent ev = (ModelActivatedPluginEvent)event;
                        for (DebuggerObjectsProvider provider : this.providers) {
                            provider.modelActivated(ev.getActiveModel());
                        }
                        break block8;
                    }
                    if (!(event instanceof ProgramActivatedPluginEvent)) break block12;
                    ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
                    for (DebuggerObjectsProvider provider : this.providers) {
                        provider.setProgram(ev.getActiveProgram());
                    }
                    break block8;
                }
                if (!(event instanceof ProgramOpenedPluginEvent)) break block13;
                ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)event;
                for (DebuggerObjectsProvider provider : this.providers) {
                    provider.setProgram(ev.getProgram());
                }
                break block8;
            }
            if (!(event instanceof ProgramSelectionPluginEvent)) break block8;
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            for (DebuggerObjectsProvider provider : this.providers) {
                provider.setProgram(ev.getProgram());
            }
        }
    }

    public void addProvider(DebuggerObjectsProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void fireObjectUpdated(ObjectContainer object) {
        ObjectUpdatedEvent event = new ObjectUpdatedEvent(object);
        Runnable r = () -> this.firePluginEvent(event);
        SwingUtilities.invokeLater(r);
    }

    public void showConsole(TargetInterpreter interpreter) {
        Swing.runIfSwingOrRunLater(() -> this.interpreterService.showConsole(interpreter));
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeModelsChangedListener((CollectionChangeListener)this);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addModelsChangedListener((CollectionChangeListener)this);
        }
    }

    public void elementAdded(DebuggerObjectModel model) {
        DebuggerObjectsProvider top = this.providers.get(this.providers.size() - 1);
        DebuggerObjectModel existingModel = top.getModel();
        if (existingModel == null) {
            top.setModel(model);
        } else {
            SwingUtilities.invokeLater(new ProviderRunnable(this, model));
        }
    }

    public void elementRemoved(DebuggerObjectModel model) {
        ArrayList<DebuggerObjectsProvider> toRemove = new ArrayList<DebuggerObjectsProvider>();
        for (DebuggerObjectsProvider p : this.providers) {
            if (!model.equals(p.getModel())) continue;
            this.tool.removeComponentProvider((ComponentProvider)p);
            toRemove.add(p);
        }
        this.writeConfigState(this.copiedSaveState);
        for (DebuggerObjectsProvider p : toRemove) {
            this.providers.remove(p);
        }
        if (this.providers.size() == 0) {
            Swing.runIfSwingOrRunLater(() -> this.init());
        }
    }

    public void elementModified(DebuggerObjectModel model) {
        System.err.println("modelModified " + model);
    }

    public void setFocus(TargetObject object, TargetObject focused) {
        for (DebuggerObjectsProvider p : this.providers) {
            p.setFocus(object, focused);
        }
    }

    public Program getActiveProgram() {
        return this.activeProgram;
    }

    public void setActiveProgram(Program program) {
        this.activeProgram = program;
    }

    public void writeConfigState(SaveState saveState) {
        if (this.providers.isEmpty()) {
            return;
        }
        this.providers.get(0).writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        this.copiedSaveState = new SaveState(saveState.saveToXml());
        if (this.providers.isEmpty()) {
            return;
        }
        this.providers.get(0).readConfigState(saveState);
    }

    public void objectError(String message) {
        if (this.consoleService == null) {
            Msg.error((Object)this, (Object)message);
            return;
        }
        this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message);
    }

    class ProviderRunnable
    implements Runnable {
        private DebuggerObjectsPlugin plugin;
        private DebuggerObjectModel model;

        ProviderRunnable(DebuggerObjectsPlugin p, DebuggerObjectModel m) {
            this.plugin = p;
            this.model = m;
        }

        @Override
        public void run() {
            try {
                DebuggerObjectsPlugin.this.writeConfigState(DebuggerObjectsPlugin.this.copiedSaveState);
                ObjectContainer container = new ObjectContainer(null, null);
                DebuggerObjectsProvider p = new DebuggerObjectsProvider(this.plugin, this.model, container, true);
                p.readConfigState(DebuggerObjectsPlugin.this.copiedSaveState);
                container.propagateProvider(p);
                p.update(container);
                p.refresh();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

