/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportExportAsAction;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ImportFromXMLAction
extends ImportExportAsAction {
    protected static final Icon ICON_XML = new GIcon("icon.debugger.display.import.xml");

    public ImportFromXMLAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("ImportFromXML", tool, owner, provider);
        this.fileExt = ".xml";
        this.fileMode = GhidraFileChooserMode.FILES_ONLY;
        this.setMenuBarData(new MenuData(new String[]{this.IMPORT, "from XML"}, ICON_XML, this.GROUP));
        this.setKeyBindingData(new KeyBindingData(69, 512));
        this.setHelpLocation(new HelpLocation(owner, "import_from_xml"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    @Override
    protected void doAction(ObjectContainer container, final File f) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is = null;
                try {
                    ObjectContainer cp = new ObjectContainer(null, null);
                    DebuggerObjectsProvider p = new DebuggerObjectsProvider(ImportFromXMLAction.this.provider.getPlugin(), ImportFromXMLAction.this.provider.getModel(), cp, true);
                    cp.propagateProvider(p);
                    p.update(cp);
                    is = new FileInputStream(f);
                    SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
                    Element root = sax.build(is).getRootElement();
                    ArrayList<String> path = new ArrayList<String>();
                    Attribute pathStr = root.getAttribute("Path");
                    for (String s : pathStr.getValue().split("\\.")) {
                        path.add(s);
                    }
                    DummyTargetObject to = ImportFromXMLAction.this.xmlToObject(p, root, path);
                    ObjectContainer c = p.getRoot();
                    c.setTargetObject(to);
                    ImportFromXMLAction.this.provider.update(c);
                }
                catch (Exception e) {
                    Msg.showError((Object)this, (Component)ImportFromXMLAction.this.provider.getComponent(), (String)"Load Failed", (Object)e.getMessage());
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    private DummyTargetObject xmlToObject(DebuggerObjectsProvider p, Element e, List<String> path) {
        String key = this.convertName(e.getName());
        Attribute type = e.getAttribute("Type");
        Attribute value = e.getAttribute("Value");
        ArrayList<TargetObject> objects = new ArrayList<TargetObject>();
        for (Object c : e.getChildren()) {
            if (!(c instanceof Element)) continue;
            Element ce = (Element)c;
            ArrayList<String> npath = new ArrayList<String>();
            npath.addAll(path);
            npath.add(this.convertName(ce.getName()));
            DummyTargetObject to = this.xmlToObject(p, ce, npath);
            objects.add(to);
        }
        String tstr = type != null ? type.getValue() : "";
        String vstr = value != null ? value.getValue() : "";
        return new DummyTargetObject(key, path, tstr, vstr, "", objects);
    }

    private String convertName(String name) {
        return name.contains("_0x") ? "[" + name.substring(name.indexOf("_") + 1) + "]" : name;
    }
}

