/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerLegacyStackPanel;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.trace.model.stack.TraceStackFrame;

public class StackFrameRow {
    private final DebuggerLegacyStackPanel panel;
    final TraceStackFrame frame;
    private int level;

    public StackFrameRow(DebuggerLegacyStackPanel panel, TraceStackFrame frame) {
        this.panel = panel;
        this.frame = frame;
        this.level = frame.getLevel();
    }

    private StackFrameRow(DebuggerLegacyStackPanel panel) {
        this.panel = panel;
        this.frame = null;
        this.level = 0;
    }

    public int getFrameLevel() {
        return this.level;
    }

    public long getSnap() {
        return this.panel.current.getSnap();
    }

    public Address getProgramCounter() {
        return this.frame.getProgramCounter(this.getSnap());
    }

    public String getComment() {
        return this.frame == null ? "" : this.frame.getComment(this.getSnap());
    }

    public void setComment(String comment) {
        try (Transaction tx = this.frame.getStack().getThread().getTrace().openTransaction("Frame comment");){
            this.frame.setComment(this.getSnap(), comment);
        }
    }

    public boolean isCommentable() {
        return this.frame != null;
    }

    public Function getFunction() {
        return this.panel.provider.getFunction(this.getProgramCounter());
    }

    protected void update() {
        assert (this.frame != null);
        this.level = this.frame.getLevel();
    }

    public static class Synthetic
    extends StackFrameRow {
        private Address pc;

        public Synthetic(DebuggerLegacyStackPanel panel, Address pc) {
            super(panel);
            this.pc = pc;
        }

        public void updateProgramCounter(Address pc) {
            this.pc = pc;
        }

        @Override
        public Address getProgramCounter() {
            return this.pc;
        }
    }
}

