/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerLegacyThreadsPanel;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPanel;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerTraceTabPanel;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.TraceChangeType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.ArrayUtils;

public class DebuggerThreadsProvider
extends ComponentProviderAdapter {
    final DebuggerThreadsPlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    Trace currentTrace;
    @AutoServiceConsumed
    DebuggerTargetService targetService;
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private final DebuggerTraceManagerService.BooleanChangeAdapter synchronizeTargetChangeListener = this::changedSynchronizeTarget;
    private final ForSnapsListener forSnapsListener = new ForSnapsListener();
    private JPanel mainPanel;
    DebuggerTraceTabPanel traceTabs;
    JPopupMenu traceTabPopupMenu;
    DebuggerThreadsPanel panel;
    DebuggerLegacyThreadsPanel legacyPanel;
    DockingAction actionSaveTrace;
    ToggleDockingAction actionSyncTarget;
    ActionContext myActionContext;
    DebuggerResources.ToToggleSelectionListener toToggleSelectionListener;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getTarget(), b.getTarget())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getTime(), b.getTime());
    }

    public DebuggerThreadsProvider(DebuggerThreadsPlugin plugin) {
        super(plugin.getTool(), "Threads", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_THREADS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_THREADS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.createActions();
        this.contextChanged();
        this.setVisible(true);
    }

    @AutoServiceConsumed
    public void setTraceManager(DebuggerTraceManagerService traceManager) {
        if (this.traceManager != null) {
            this.traceManager.removeSynchronizeActiveChangeListener(this.synchronizeTargetChangeListener);
        }
        this.traceManager = traceManager;
        if (traceManager != null) {
            traceManager.addSynchronizeActiveChangeListener(this.synchronizeTargetChangeListener);
            if (this.actionSyncTarget != null) {
                this.actionSyncTarget.setSelected(traceManager.isSynchronizeActive());
            }
        }
        this.contextChanged();
    }

    @AutoServiceConsumed
    public void setEmulationService(DebuggerEmulationService emulationService) {
        this.contextChanged();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerThreadsProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.traceTabs.coordinatesActivated(coordinates);
        if (Trace.isLegacy((Trace)coordinates.getTrace())) {
            this.panel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacyPanel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.legacyPanel) == -1) {
                this.mainPanel.remove(this.panel);
                this.mainPanel.add(this.legacyPanel);
                this.mainPanel.validate();
            }
        } else {
            this.legacyPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.panel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.panel) == -1) {
                this.mainPanel.remove(this.legacyPanel);
                this.mainPanel.add(this.panel);
                this.mainPanel.validate();
            }
        }
        this.forSnapsListener.setTrace(coordinates.getTrace());
        this.setSubTitle(coordinates.getTime().toString());
        this.contextChanged();
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    void threadsPanelContextChanged() {
        this.myActionContext = this.panel.getActionContext();
    }

    void legacyThreadsPanelContextChanged() {
        this.myActionContext = this.legacyPanel.getActionContext();
    }

    void traceTabsContextChanged() {
        this.myActionContext = this.traceTabs.getActionContext();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void buildMainPanel() {
        this.traceTabPopupMenu = new JPopupMenu("Trace");
        this.mainPanel = new JPanel(new BorderLayout());
        this.panel = new DebuggerThreadsPanel(this);
        this.legacyPanel = new DebuggerLegacyThreadsPanel(this.plugin, this);
        this.mainPanel.add(this.panel);
        this.traceTabs = new DebuggerTraceTabPanel(this);
        this.mainPanel.add((Component)((Object)this.traceTabs), "North");
    }

    protected void createActions() {
        this.actionSyncTarget = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.SynchronizeTargetAction.builder(this.plugin).selected(this.traceManager != null && this.traceManager.isSynchronizeActive()).enabledWhen(c -> this.traceManager != null)).onAction(c -> this.toggleSyncFocus(this.actionSyncTarget.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.toToggleSelectionListener = new DebuggerResources.ToToggleSelectionListener(this.actionSyncTarget);
        this.traceManager.addSynchronizeActiveChangeListener((DebuggerTraceManagerService.BooleanChangeAdapter)this.toToggleSelectionListener);
    }

    private void changedSynchronizeTarget(boolean value) {
        if (this.actionSyncTarget == null || this.actionSyncTarget.isSelected()) {
            return;
        }
        this.actionSyncTarget.setSelected(value);
    }

    private void toggleSyncFocus(boolean enabled) {
        if (this.traceManager == null) {
            return;
        }
        this.traceManager.setSynchronizeActive(enabled);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private class ForSnapsListener
    extends TraceDomainObjectListener {
        private Trace currentTrace;

        public ForSnapsListener() {
            this.listenForUntyped(4, this::objectRestored);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.ADDED, this::snapAdded);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.DELETED, this::snapDeleted);
        }

        private void setTrace(Trace trace) {
            if (this.currentTrace != null) {
                this.currentTrace.removeListener((DomainObjectListener)this);
            }
            this.currentTrace = trace;
            if (this.currentTrace != null) {
                this.currentTrace.addListener((DomainObjectListener)this);
            }
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            DebuggerThreadsProvider.this.contextChanged();
        }

        private void snapAdded(TraceSnapshot snapshot) {
            DebuggerThreadsProvider.this.contextChanged();
        }

        private void snapDeleted() {
            DebuggerThreadsProvider.this.contextChanged();
        }
    }
}

