/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.widgets.HorizontalTabPanel;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsProvider;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerTraceFileActionContext;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.trace.model.Trace;
import ghidra.util.Swing;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import utilities.util.SuppressableCallback;

public class DebuggerTraceTabPanel
extends HorizontalTabPanel<Trace>
implements PluginEventListener {
    private final DebuggerThreadsPlugin plugin;
    private final DebuggerThreadsProvider provider;
    DebuggerTargetService targetService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private final TargetsChangeListener targetsListener = new TargetsChangeListener();
    DockingAction actionCloseTrace;
    DockingAction actionCloseOtherTraces;
    DockingAction actionCloseDeadTraces;
    DockingAction actionCloseAllTraces;
    private final SuppressableCallback<Void> cbCoordinateActivation = new SuppressableCallback();
    private DebuggerTraceFileActionContext myActionContext;

    public DebuggerTraceTabPanel(DebuggerThreadsProvider provider) {
        this.plugin = provider.plugin;
        this.provider = provider;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)this.plugin, (Object)((Object)this));
        PluginTool tool = this.plugin.getTool();
        tool.addEventListener(TraceOpenedPluginEvent.class, (PluginEventListener)this);
        tool.addEventListener(TraceClosedPluginEvent.class, (PluginEventListener)this);
        this.list.setCellRenderer(new HorizontalTabPanel.TabListCellRenderer<Trace>(){

            protected String getText(Trace value) {
                return value.getName();
            }

            protected Icon getIcon(Trace value) {
                if (DebuggerTraceTabPanel.this.targetService == null) {
                    return super.getIcon((Object)value);
                }
                Target target = DebuggerTraceTabPanel.this.targetService.getTarget(value);
                if (target == null || !target.isValid()) {
                    return super.getIcon((Object)value);
                }
                return DebuggerResources.ICON_RECORD;
            }
        });
        this.list.getSelectionModel().addListSelectionListener(this::traceTabSelected);
        this.list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DebuggerTraceTabPanel.this.setTraceTabActionContext(null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DebuggerTraceTabPanel.this.setTraceTabActionContext(e);
            }
        });
        this.actionCloseTrace = (DockingAction)DebuggerResources.CloseTraceAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> c.getTrace() != null).onAction(c -> this.traceManager.closeTrace(c.getTrace())).buildAndInstallLocal((ComponentProvider)provider);
        this.actionCloseAllTraces = (DockingAction)DebuggerResources.CloseAllTracesAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> !this.traceManager.getOpenTraces().isEmpty()).onAction(c -> this.traceManager.closeAllTraces()).buildAndInstallLocal((ComponentProvider)provider);
        this.actionCloseOtherTraces = (DockingAction)DebuggerResources.CloseOtherTracesAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> this.traceManager.getOpenTraces().size() > 1 && c.getTrace() != null).onAction(c -> this.traceManager.closeOtherTraces(c.getTrace())).buildAndInstallLocal((ComponentProvider)provider);
        this.actionCloseDeadTraces = (DockingAction)DebuggerResources.CloseDeadTracesAction.builderPopup(this.plugin).withContext(DebuggerTraceFileActionContext.class).popupWhen(c -> !this.traceManager.getOpenTraces().isEmpty() && this.targetService != null).onAction(c -> this.traceManager.closeDeadTraces()).buildAndInstallLocal((ComponentProvider)provider);
    }

    private Trace computeClickedTraceTab(MouseEvent e) {
        JList list = this.getList();
        int i = list.locationToIndex(e.getPoint());
        if (i < 0) {
            return null;
        }
        Rectangle cell = list.getCellBounds(i, i);
        if (!cell.contains(e.getPoint())) {
            return null;
        }
        return (Trace)this.getItem(i);
    }

    private Trace setTraceTabActionContext(MouseEvent e) {
        Trace newTrace = e == null ? (Trace)this.getSelectedItem() : this.computeClickedTraceTab(e);
        this.actionCloseTrace.getPopupMenuData().setMenuItemName("Close " + (newTrace == null ? "..." : newTrace.getName()));
        this.myActionContext = new DebuggerTraceFileActionContext(newTrace);
        this.provider.traceTabsContextChanged();
        return newTrace;
    }

    public DebuggerTraceFileActionContext getActionContext() {
        return this.myActionContext;
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
            this.setSelectedItem(coordinates.getTrace());
        }
    }

    @AutoServiceConsumed
    public void setTargetService(DebuggerTargetService targetService) {
        if (this.targetService != null) {
            this.targetService.removeTargetPublicationListener((TargetPublicationListener)this.targetsListener);
        }
        this.targetService = targetService;
        if (this.targetService != null) {
            this.targetService.addTargetPublicationListener((TargetPublicationListener)this.targetsListener);
        }
    }

    public void eventSent(PluginEvent event) {
        if (Objects.equals(event.getSourceName(), this.plugin.getName())) {
            return;
        }
        if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent evt = (TraceOpenedPluginEvent)event;
            try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
                this.addItem(evt.getTrace());
            }
        }
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            try (SuppressableCallback.Suppression supp = this.cbCoordinateActivation.suppress(null);){
                this.removeItem(evt.getTrace());
            }
        }
    }

    private void traceTabSelected(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Trace newTrace = this.setTraceTabActionContext(null);
        this.cbCoordinateActivation.invoke(() -> this.traceManager.activateTrace(newTrace));
    }

    private class TargetsChangeListener
    implements TargetPublicationListener {
        private TargetsChangeListener() {
        }

        public void targetPublished(Target target) {
            Swing.runIfSwingOrRunLater(() -> DebuggerTraceTabPanel.this.repaint());
        }

        public void targetWithdrawn(Target target) {
            Swing.runIfSwingOrRunLater(() -> DebuggerTraceTabPanel.this.repaint());
        }
    }
}

