/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.debug.api.model.DebuggerRegisterMapper;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DefaultDebuggerRegisterMapper
implements DebuggerRegisterMapper {
    protected final Language language;
    protected final CompilerSpec cspec;
    protected final boolean caseSensitive;
    protected final Map<String, Register> languageRegs = new LinkedHashMap<String, Register>();
    protected final Map<String, Register> filtLanguageRegs = new LinkedHashMap<String, Register>();
    protected final Map<String, TargetRegister> targetRegs = new HashMap<String, TargetRegister>();

    public DefaultDebuggerRegisterMapper(CompilerSpec cSpec, TargetRegisterContainer targetRegContainer, boolean caseSensitive) {
        this.language = cSpec.getLanguage();
        this.cspec = cSpec;
        this.caseSensitive = caseSensitive;
        this.collectFilteredLanguageRegs();
    }

    protected boolean includeTraceRegister(Register lReg) {
        return lReg.isBaseRegister();
    }

    protected synchronized void collectFilteredLanguageRegs() {
        for (Register lReg : this.language.getRegisters()) {
            if (!this.includeTraceRegister(lReg)) continue;
            this.putLanguageRegister(this.filtLanguageRegs, lReg);
        }
    }

    protected synchronized void putLanguageRegister(Map<String, Register> map, Register lReg) {
        map.put(this.normalizeName(lReg.getName()), lReg);
        for (String alias : lReg.getAliases()) {
            map.put(this.normalizeName(alias), lReg);
        }
    }

    protected synchronized void removeLanguageRegister(Map<String, Register> map, Register lReg) {
        map.remove(this.normalizeName(lReg.getName()));
        for (String alias : lReg.getAliases()) {
            map.remove(this.normalizeName(alias));
        }
    }

    protected synchronized Register considerRegister(String index) {
        String name = this.normalizeName(index);
        Register lReg = this.filtLanguageRegs.get(name);
        if (lReg == null) {
            return null;
        }
        this.putLanguageRegister(this.languageRegs, lReg);
        return lReg;
    }

    protected synchronized Register considerRegister(TargetRegister tReg) {
        String name = this.normalizeName(tReg.getIndex());
        Register lReg = this.filtLanguageRegs.get(name);
        if (lReg == null) {
            return null;
        }
        this.targetRegs.put(name, tReg);
        this.putLanguageRegister(this.languageRegs, lReg);
        return lReg;
    }

    protected synchronized Register removeRegister(TargetRegister tReg) {
        String name = this.normalizeName(tReg.getIndex());
        Register lReg = this.filtLanguageRegs.get(name);
        if (lReg == null) {
            return null;
        }
        this.targetRegs.remove(name);
        this.removeLanguageRegister(this.languageRegs, lReg);
        return lReg;
    }

    protected String normalizeName(String name) {
        if (this.caseSensitive) {
            return name;
        }
        return name.toLowerCase();
    }

    public synchronized TargetRegister getTargetRegister(String name) {
        return this.targetRegs.get(this.normalizeName(name));
    }

    public synchronized Register getTraceRegister(String name) {
        return this.languageRegs.get(this.normalizeName(name));
    }

    public synchronized TargetRegister traceToTarget(Register lReg) {
        TargetRegister tReg = this.targetRegs.get(this.normalizeName(lReg.getName()));
        if (tReg != null) {
            return tReg;
        }
        for (String alias : lReg.getAliases()) {
            tReg = this.targetRegs.get(this.normalizeName(alias));
            if (tReg == null) continue;
            return tReg;
        }
        return null;
    }

    public synchronized Register targetToTrace(TargetRegister tReg) {
        return this.languageRegs.get(this.normalizeName(tReg.getIndex()));
    }

    public synchronized Set<Register> getRegistersOnTarget() {
        return Set.copyOf(this.languageRegs.values());
    }

    public synchronized void targetRegisterAdded(TargetRegister register) {
        this.considerRegister(register);
    }

    public synchronized void targetRegisterRemoved(TargetRegister register) {
        this.removeRegister(register);
    }
}

