/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.debug.api.model.DebuggerMemoryMapper;
import ghidra.debug.api.model.DebuggerRegisterMapper;
import ghidra.debug.api.model.DebuggerTargetTraceMapper;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.Trace;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DefaultDebuggerTargetTraceMapper
implements DebuggerTargetTraceMapper {
    protected final TargetObject target;
    protected final Language language;
    protected final CompilerSpec cSpec;
    protected final Set<String> extraRegNames;

    public DefaultDebuggerTargetTraceMapper(TargetObject target, LanguageID langID, CompilerSpecID csID, Collection<String> extraRegNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
        this.target = target;
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        this.language = langServ.getLanguage(langID);
        this.cSpec = this.language.getCompilerSpecByID(csID);
        this.extraRegNames = Set.copyOf(extraRegNames);
    }

    protected DebuggerMemoryMapper createMemoryMapper(TargetMemory memory) {
        return new DefaultDebuggerMemoryMapper(this.language, memory.getModel());
    }

    protected DebuggerRegisterMapper createRegisterMapper(TargetRegisterContainer registers) {
        return new DefaultDebuggerRegisterMapper(this.cSpec, registers, false);
    }

    public CompletableFuture<DebuggerMemoryMapper> offerMemory(TargetMemory memory) {
        DebuggerMemoryMapper mm = this.createMemoryMapper(memory);
        return CompletableFuture.completedFuture(mm);
    }

    public CompletableFuture<DebuggerRegisterMapper> offerRegisters(TargetRegisterContainer registers) {
        DebuggerRegisterMapper rm = this.createRegisterMapper(registers);
        return CompletableFuture.completedFuture(rm);
    }

    public Set<String> getExtraRegNames() {
        return this.extraRegNames;
    }

    public Language getTraceLanguage() {
        return this.language;
    }

    public CompilerSpec getTraceCompilerSpec() {
        return this.cSpec;
    }

    public TraceRecorder startRecording(PluginTool tool, Trace trace) {
        return new DefaultTraceRecorder(tool, trace, this.target, this);
    }
}

