/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform;

import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerPlatformMapper;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OverrideDebuggerPlatformOpinion
extends AbstractDebuggerPlatformOpinion {
    private static final LanguageCompilerSpecQuery ALL_SPECS = new LanguageCompilerSpecQuery(null, null, null, null, null);
    private static final Map<Endian, Set<DebuggerPlatformOffer>> CACHE = new HashMap<Endian, Set<DebuggerPlatformOffer>>();

    protected DebuggerPlatformOffer computeOfferForEndianAndLCSP(Endian endian, LanguageCompilerSpecPair lcsp) {
        try {
            LanguageDescription ldesc = lcsp.getLanguageDescription();
            return new OverridePlatformOffer("Override to " + lcsp, ldesc.getLanguageID(), lcsp.getCompilerSpecDescription().getCompilerSpecID(), ldesc.getEndian() == endian ? -10 : -20);
        }
        catch (CompilerSpecNotFoundException | LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Set<DebuggerPlatformOffer> computeOffersForEndian(Endian endian) {
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        return langServ.getLanguageCompilerSpecPairs(ALL_SPECS).stream().map(lcsp -> this.computeOfferForEndianAndLCSP(endian, (LanguageCompilerSpecPair)lcsp)).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<DebuggerPlatformOffer> getOffers(TraceObject object, long snap, TraceObject env, String debugger, String arch, String os, Endian endian, boolean includeOverrides) {
        if (!includeOverrides) {
            return Set.of();
        }
        Map<Endian, Set<DebuggerPlatformOffer>> map = CACHE;
        synchronized (map) {
            return CACHE.computeIfAbsent(endian, this::computeOffersForEndian);
        }
    }

    protected static class OverridePlatformOffer
    implements DebuggerPlatformOffer {
        private final String description;
        private final LanguageID languageID;
        private final CompilerSpecID cSpecID;
        private final int confidence;

        public OverridePlatformOffer(String description, LanguageID languageID, CompilerSpecID cSpecID, int confidence) {
            this.description = description;
            this.languageID = languageID;
            this.cSpecID = cSpecID;
            this.confidence = confidence;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public LanguageID getLanguageID() {
            return this.languageID;
        }

        @Override
        public CompilerSpecID getCompilerSpecID() {
            return this.cSpecID;
        }

        @Override
        public int getConfidence() {
            return this.confidence;
        }

        @Override
        public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
            return new OverrideDebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
        }

        @Override
        public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
            return mapper.getClass() == OverrideDebuggerPlatformMapper.class;
        }

        @Override
        public CompilerSpec getCompilerSpec() {
            return this.getCompilerSpec(this.languageID, this.cSpecID);
        }
    }

    protected static class OverrideDebuggerPlatformMapper
    extends DefaultDebuggerPlatformMapper {
        public OverrideDebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }
    }
}

