/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.debug.api.model.DebuggerMappingOpinion;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import java.util.Set;

public class GdbMipsDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_MIPS32_BE = new LanguageID("MIPS:BE:32:default");
    protected static final LanguageID LANG_ID_MIPS64_BE = new LanguageID("MIPS:BE:64:default");
    protected static final LanguageID LANG_ID_MIPS64_32BE = new LanguageID("MIPS:BE:64:64-32addr");
    protected static final LanguageID LANG_ID_MIPS32_BE_R6 = new LanguageID("MIPS:BE:32:R6");
    protected static final LanguageID LANG_ID_MIPS64_BE_R6 = new LanguageID("MIPS:BE:64:R6");
    protected static final LanguageID LANG_ID_MIPS32_BE_MICRO = new LanguageID("MIPS:BE:32:micro");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");

    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        TargetProcess process = (TargetProcess)target;
        if (!env.getDebugger().toLowerCase().contains("gdb")) {
            return Set.of();
        }
        String os = env.getOperatingSystem();
        if (!os.contains("Linux")) {
            return Set.of();
        }
        String endian = env.getEndian();
        if (!endian.contains("big")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        if (arch.startsWith("mips:32")) {
            return Set.of(new GdbMipsBELinux32DefOffer(process));
        }
        if (arch.startsWith("mips:64")) {
            return Set.of(new GdbMipsBELinux64DefOffer(process));
        }
        if (arch.startsWith("mips:64_32")) {
            return Set.of(new GdbMipsBELinux64_32Offer(process));
        }
        if (arch.startsWith("mips:32_R6")) {
            return Set.of(new GdbMipsBELinux32_R6Offer(process));
        }
        if (arch.startsWith("mips:64_R6")) {
            return Set.of(new GdbMipsBELinux64_R6Offer(process));
        }
        if (arch.startsWith("mips:32_micro")) {
            return Set.of(new GdbMipsBELinux32MicroOffer(process));
        }
        if (arch.startsWith("mips")) {
            return Set.of(new GdbMipsBELinux64DefOffer(process));
        }
        return Set.of();
    }

    protected static class GdbMipsBELinux32DefOffer
    extends DefaultDebuggerMappingOffer {
        public GdbMipsBELinux32DefOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux mips - 32-bit", LANG_ID_MIPS32_BE, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbMipsBELinux64DefOffer
    extends DefaultDebuggerMappingOffer {
        public GdbMipsBELinux64DefOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux mips - 64-bit", LANG_ID_MIPS64_BE, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbMipsBELinux64_32Offer
    extends DefaultDebuggerMappingOffer {
        public GdbMipsBELinux64_32Offer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux mips - 64/32-bit", LANG_ID_MIPS64_32BE, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbMipsBELinux32_R6Offer
    extends DefaultDebuggerMappingOffer {
        public GdbMipsBELinux32_R6Offer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux mips - 32-bit R6", LANG_ID_MIPS32_BE_R6, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbMipsBELinux64_R6Offer
    extends DefaultDebuggerMappingOffer {
        public GdbMipsBELinux64_R6Offer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux mips - 64-bit R6", LANG_ID_MIPS64_BE_R6, COMP_ID_DEFAULT, Set.of());
        }
    }

    protected static class GdbMipsBELinux32MicroOffer
    extends DefaultDebuggerMappingOffer {
        public GdbMipsBELinux32MicroOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux mips - 32-bit micro", LANG_ID_MIPS32_BE_MICRO, COMP_ID_DEFAULT, Set.of());
        }
    }
}

