/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation.data;

import ghidra.app.plugin.core.debug.service.emulation.data.InternalPcodeDebuggerDataAccess;
import ghidra.debug.api.emulation.PcodeDebuggerRegistersAccess;
import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceRegistersAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.thread.TraceThread;
import java.util.concurrent.CompletableFuture;

public class DefaultPcodeDebuggerRegistersAccess
extends DefaultPcodeTraceRegistersAccess
implements PcodeDebuggerRegistersAccess,
InternalPcodeDebuggerDataAccess {
    protected final PluginTool tool;
    protected final Target target;

    protected DefaultPcodeDebuggerRegistersAccess(PluginTool tool, Target target, TracePlatform platform, long snap, TraceThread thread, int frame, TraceTimeViewport viewport) {
        super(platform, snap, thread, frame, viewport);
        this.tool = tool;
        this.target = target;
    }

    @Override
    public boolean isLive() {
        return InternalPcodeDebuggerDataAccess.super.isLive();
    }

    @Override
    public PluginTool getTool() {
        return this.tool;
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    public CompletableFuture<Boolean> readFromTargetRegisters(AddressSetView guestView) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.target.readRegistersAsync(this.platform, this.thread, this.frame, guestView).thenApply(__ -> true);
    }

    public CompletableFuture<Boolean> writeTargetRegister(Address address, byte[] data) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.target.writeRegisterAsync(this.platform, this.thread, this.frame, address, data).thenApply(__ -> true);
    }
}

